<?php

namespace App\Models {

    /**
     * App\Models\User
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $is_admin
     * @property string|null $remember_token
     * @property string $password
     * @property \Illuminate\Support\Carbon|null $email_verified_at
     * @property string|null $profile_image
     * @property string $currency
     * @property string|null $country
     * @property string $email
     * @property string $name
     * @property int $id
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Purchase> $purchases
     * @property-read int|null $purchases_count
     * @property-read \App\Models\Wallet $wallet
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\InvestmentHolding> $investmentHoldings
     * @property-read int|null $investmentHoldings_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\InvestmentTransaction> $investmentTransactions
     * @property-read int|null $investmentTransactions_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\StockHolding> $stockHoldings
     * @property-read int|null $stockHoldings_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\StockTransaction> $stockTransactions
     * @property-read int|null $stockTransactions_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\InvestmentWatchlist> $investmentWatchlist
     * @property-read int|null $investmentWatchlist_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\StockWatchlist> $stockWatchlist
     * @property-read int|null $stockWatchlist_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\AutomaticInvestmentPlan> $automaticInvestmentPlans
     * @property-read int|null $automaticInvestmentPlans_count
     * @property-read \App\Models\KYC $kyc
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Notification> $notifications
     * @property-read int|null $notifications_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\MembershipCard> $membershipCards
     * @property-read int|null $membershipCards_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\MembershipPurchase> $membershipPurchases
     * @property-read int|null $membershipPurchases_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\GiveawayEntry> $giveawayEntries
     * @property-read int|null $giveawayEntries_count
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereEmail($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereCountry($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereCurrency($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereProfileImage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereEmailVerifiedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User wherePassword($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereRememberToken($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereIsAdmin($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User query()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static User|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User clone()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static User|null first(array|string $columns)
     * @method static User firstOrFail(array|string $columns, string|null $message)
     * @method static User sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class User extends \Illuminate\Foundation\Auth\User
    {
        //
    }

    /**
     * App\Models\ApiRequestLog
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property \Illuminate\Support\Carbon $requested_at
     * @property string|null $rate_limit_type
     * @property array|null $response_data
     * @property array|null $request_params
     * @property string|null $error_message
     * @property boolean $success
     * @property integer|null $status_code
     * @property integer|null $response_time_ms
     * @property string|null $symbol
     * @property string $endpoint
     * @property string $api_provider
     * @property int $id
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereApiProvider($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereEndpoint($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereSymbol($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereResponseTimeMs($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereStatusCode($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereSuccess($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereErrorMessage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereRequestParams($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereResponseData($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereRateLimitType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereRequestedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog query()
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static ApiRequestLog|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog clone()
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static ApiRequestLog|null first(array|string $columns)
     * @method static ApiRequestLog firstOrFail(array|string $columns, string|null $message)
     * @method static ApiRequestLog sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<ApiRequestLog>|ApiRequestLog tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class ApiRequestLog extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\AutomaticInvestmentPlan
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property \Illuminate\Support\Carbon|null $next_investment_date
     * @property boolean $is_active
     * @property mixed $day_of_month
     * @property mixed $frequency
     * @property float $amount
     * @property mixed $investment_plan_id
     * @property mixed $user_id
     * @property int $id
     * @property-read mixed $formatted_amount
     * @property-read mixed $frequency_label
     * @property-read mixed $formatted_next_investment_date
     * @property-read \App\Models\User $user
     * @property-read \App\Models\InvestmentPlan $investmentPlan
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereInvestmentPlanId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereFrequency($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereDayOfMonth($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereIsActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereNextInvestmentDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan query()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan active() {@see App\Models\AutomaticInvestmentPlan::scopeActive()}
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan dueForInvestment() {@see App\Models\AutomaticInvestmentPlan::scopeDueForInvestment()}
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static AutomaticInvestmentPlan|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan clone()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static AutomaticInvestmentPlan|null first(array|string $columns)
     * @method static AutomaticInvestmentPlan firstOrFail(array|string $columns, string|null $message)
     * @method static AutomaticInvestmentPlan sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticInvestmentPlan>|AutomaticInvestmentPlan tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class AutomaticInvestmentPlan extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\AutomaticNavUpdate
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property mixed $created_by
     * @property integer $total_executions
     * @property boolean $is_active
     * @property \Illuminate\Support\Carbon|null $next_execution_at
     * @property \Illuminate\Support\Carbon|null $last_executed_at
     * @property \Illuminate\Support\Carbon|null $end_date
     * @property \Illuminate\Support\Carbon|null $start_date
     * @property mixed $update_interval_unit
     * @property integer $update_interval_value
     * @property float $update_amount
     * @property mixed $update_type
     * @property string|null $description
     * @property string $name
     * @property mixed $investment_plan_id
     * @property int $id
     * @property-read \App\Models\InvestmentPlan $investmentPlan
     * @property-read \App\Models\User $creator
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereInvestmentPlanId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereUpdateType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereUpdateAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereUpdateIntervalValue($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereUpdateIntervalUnit($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereStartDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereEndDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereLastExecutedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereNextExecutionAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereIsActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereTotalExecutions($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereCreatedBy($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate query()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate active() {@see App\Models\AutomaticNavUpdate::scopeActive()}
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate due() {@see App\Models\AutomaticNavUpdate::scopeDue()}
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate forPlan(mixed $planId) {@see App\Models\AutomaticNavUpdate::scopeForPlan()}
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static AutomaticNavUpdate|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate clone()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static AutomaticNavUpdate|null first(array|string $columns)
     * @method static AutomaticNavUpdate firstOrFail(array|string $columns, string|null $message)
     * @method static AutomaticNavUpdate sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<AutomaticNavUpdate>|AutomaticNavUpdate tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class AutomaticNavUpdate extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Car
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $is_available
     * @property array|null $images
     * @property float $price
     * @property string $color
     * @property string $transmission
     * @property string $engine
     * @property mixed $year
     * @property string $model
     * @property string $make
     * @property string $description
     * @property string $title
     * @property int $id
     * @property-read mixed $first_image
     * @property-read mixed $formatted_price
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Purchase> $purchases
     * @property-read int|null $purchases_count
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereTitle($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereMake($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereModel($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereYear($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereEngine($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereTransmission($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereColor($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car wherePrice($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereImages($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereIsAvailable($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car query()
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Car|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Car|null first(array|string $columns)
     * @method static Car firstOrFail(array|string $columns, string|null $message)
     * @method static Car sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Car>|Car tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Car extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Contact
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property int $id
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact query()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Contact|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Contact|null first(array|string $columns)
     * @method static Contact firstOrFail(array|string $columns, string|null $message)
     * @method static Contact sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Contact extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\CurrencyRate
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property \Illuminate\Support\Carbon $last_updated
     * @property float $rate
     * @property string $currency
     * @property int $id
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereCurrency($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereRate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereLastUpdated($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate query()
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static CurrencyRate|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate clone()
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static CurrencyRate|null first(array|string $columns)
     * @method static CurrencyRate firstOrFail(array|string $columns, string|null $message)
     * @method static CurrencyRate sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<CurrencyRate>|CurrencyRate tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class CurrencyRate extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\EmailTemplate
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $is_active
     * @property string $type
     * @property array|null $variables
     * @property string $content
     * @property string $subject
     * @property string $name
     * @property int $id
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereSubject($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereContent($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereVariables($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereIsActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate query()
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate active() {@see App\Models\EmailTemplate::scopeActive()}
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate byType(mixed $type) {@see App\Models\EmailTemplate::scopeByType()}
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static EmailTemplate|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate clone()
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static EmailTemplate|null first(array|string $columns)
     * @method static EmailTemplate firstOrFail(array|string $columns, string|null $message)
     * @method static EmailTemplate sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<EmailTemplate>|EmailTemplate tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class EmailTemplate extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Giveaway
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $is_featured
     * @property mixed $status
     * @property \Illuminate\Support\Carbon|null $winner_selected_at
     * @property mixed $winner_user_id
     * @property \Illuminate\Support\Carbon|null $end_date
     * @property \Illuminate\Support\Carbon|null $start_date
     * @property mixed $entry_requirement
     * @property mixed $max_entries
     * @property string|null $prize_details
     * @property mixed $prize_car_id
     * @property string $currency
     * @property float|null $prize_value
     * @property mixed $prize_type
     * @property string|null $image_path
     * @property string|null $description
     * @property string $title
     * @property int $id
     * @property-read mixed $image_url
     * @property-read mixed $formatted_prize_value
     * @property-read mixed $total_entries
     * @property-read mixed $unique_participants
     * @property-read mixed $is_active
     * @property-read mixed $is_ended
     * @property-read mixed $has_winner
     * @property-read mixed $days_remaining
     * @property-read mixed $status_badge
     * @property-read mixed $entry_requirement_label
     * @property-read \App\Models\Car $prizeCar
     * @property-read \App\Models\User $winner
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\GiveawayEntry> $entries
     * @property-read int|null $entries_count
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereTitle($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereImagePath($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway wherePrizeType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway wherePrizeValue($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereCurrency($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway wherePrizeCarId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway wherePrizeDetails($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereMaxEntries($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereEntryRequirement($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereStartDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereEndDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereWinnerUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereWinnerSelectedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereIsFeatured($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway query()
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway active() {@see App\Models\Giveaway::scopeActive()}
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway upcoming() {@see App\Models\Giveaway::scopeUpcoming()}
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway ended() {@see App\Models\Giveaway::scopeEnded()}
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway featured() {@see App\Models\Giveaway::scopeFeatured()}
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Giveaway|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Giveaway|null first(array|string $columns)
     * @method static Giveaway firstOrFail(array|string $columns, string|null $message)
     * @method static Giveaway sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Giveaway>|Giveaway tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Giveaway extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\GiveawayEntry
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property \Illuminate\Support\Carbon $entered_at
     * @property mixed $source_purchase_id
     * @property mixed $entry_source
     * @property integer $entries_count
     * @property mixed $user_id
     * @property mixed $giveaway_id
     * @property int $id
     * @property-read mixed $entry_source_label
     * @property-read mixed $multiplier_badge
     * @property-read \App\Models\Giveaway $giveaway
     * @property-read \App\Models\User $user
     * @property-read \App\Models\Purchase $sourcePurchase
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereGiveawayId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereEntriesCount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereEntrySource($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereSourcePurchaseId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereEnteredAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry query()
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static GiveawayEntry|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry clone()
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static GiveawayEntry|null first(array|string $columns)
     * @method static GiveawayEntry firstOrFail(array|string $columns, string|null $message)
     * @method static GiveawayEntry sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<GiveawayEntry>|GiveawayEntry tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class GiveawayEntry extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\InvestmentCategory
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $is_active
     * @property string|null $icon
     * @property string $color
     * @property string|null $description
     * @property string $name
     * @property int $id
     * @property-read mixed $formatted_color
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\InvestmentPlan> $investmentPlans
     * @property-read int|null $investmentPlans_count
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereColor($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereIcon($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereIsActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory query()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory active() {@see App\Models\InvestmentCategory::scopeActive()}
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static InvestmentCategory|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory clone()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static InvestmentCategory|null first(array|string $columns)
     * @method static InvestmentCategory firstOrFail(array|string $columns, string|null $message)
     * @method static InvestmentCategory sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentCategory>|InvestmentCategory tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class InvestmentCategory extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\InvestmentHolding
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property float|null $nav_at_purchase
     * @property float|null $last_notified_change_percentage
     * @property float $unrealized_gain_loss_percentage
     * @property float $unrealized_gain_loss
     * @property float $current_value
     * @property float $total_invested
     * @property float $average_cost
     * @property float $units
     * @property mixed $investment_plan_id
     * @property mixed $user_id
     * @property int $id
     * @property-read mixed $formatted_current_value
     * @property-read mixed $gain_loss_color
     * @property-read mixed $formatted_units
     * @property-read mixed $formatted_average_cost
     * @property-read mixed $formatted_total_invested
     * @property-read \App\Models\User $user
     * @property-read \App\Models\InvestmentPlan $investmentPlan
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereInvestmentPlanId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereUnits($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereAverageCost($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereTotalInvested($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereCurrentValue($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereUnrealizedGainLoss($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereUnrealizedGainLossPercentage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereLastNotifiedChangePercentage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereNavAtPurchase($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding query()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static InvestmentHolding|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding clone()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static InvestmentHolding|null first(array|string $columns)
     * @method static InvestmentHolding firstOrFail(array|string $columns, string|null $message)
     * @method static InvestmentHolding sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentHolding>|InvestmentHolding tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class InvestmentHolding extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\InvestmentTransaction
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property \Illuminate\Support\Carbon|null $executed_at
     * @property mixed $status
     * @property float $fee
     * @property float $total_amount
     * @property float $nav_at_transaction
     * @property float $units
     * @property mixed $type
     * @property mixed $wallet_transaction_id
     * @property mixed $investment_plan_id
     * @property mixed $user_id
     * @property int $id
     * @property-read mixed $formatted_units
     * @property-read mixed $formatted_nav_at_transaction
     * @property-read mixed $formatted_total_amount
     * @property-read mixed $formatted_fee
     * @property-read mixed $formatted_executed_at
     * @property-read mixed $type_label
     * @property-read mixed $status_badge
     * @property-read \App\Models\User $user
     * @property-read \App\Models\InvestmentPlan $investmentPlan
     * @property-read \App\Models\WalletTransaction $walletTransaction
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereInvestmentPlanId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereWalletTransactionId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereUnits($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereNavAtTransaction($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereTotalAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereFee($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereExecutedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction query()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction byType(mixed $type) {@see App\Models\InvestmentTransaction::scopeByType()}
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction byStatus(mixed $status) {@see App\Models\InvestmentTransaction::scopeByStatus()}
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction completed() {@see App\Models\InvestmentTransaction::scopeCompleted()}
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction pending() {@see App\Models\InvestmentTransaction::scopePending()}
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction buys() {@see App\Models\InvestmentTransaction::scopeBuys()}
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction sells() {@see App\Models\InvestmentTransaction::scopeSells()}
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction automaticInvestments() {@see App\Models\InvestmentTransaction::scopeAutomaticInvestments()}
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction dividendReinvestments() {@see App\Models\InvestmentTransaction::scopeDividendReinvestments()}
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static InvestmentTransaction|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction clone()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static InvestmentTransaction|null first(array|string $columns)
     * @method static InvestmentTransaction firstOrFail(array|string $columns, string|null $message)
     * @method static InvestmentTransaction sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentTransaction>|InvestmentTransaction tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class InvestmentTransaction extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\InvestmentWatchlist
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property mixed $alert_type
     * @property float|null $alert_nav
     * @property mixed $investment_plan_id
     * @property mixed $user_id
     * @property int $id
     * @property-read mixed $formatted_alert_nav
     * @property-read mixed $alert_type_label
     * @property-read \App\Models\User $user
     * @property-read \App\Models\InvestmentPlan $investmentPlan
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereInvestmentPlanId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereAlertNav($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereAlertType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist query()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static InvestmentWatchlist|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist clone()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static InvestmentWatchlist|null first(array|string $columns)
     * @method static InvestmentWatchlist firstOrFail(array|string $columns, string|null $message)
     * @method static InvestmentWatchlist sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<InvestmentWatchlist>|InvestmentWatchlist tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class InvestmentWatchlist extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\KYC
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property \Illuminate\Support\Carbon|null $verified_at
     * @property \Illuminate\Support\Carbon|null $submitted_at
     * @property string|null $rejection_reason
     * @property mixed $status
     * @property string|null $selfie_path
     * @property string|null $document_back_path
     * @property string|null $document_front_path
     * @property string $phone_number
     * @property string $country
     * @property string $postal_code
     * @property string $state_province
     * @property string $city
     * @property string|null $address_line_2
     * @property string $address_line_1
     * @property \Illuminate\Support\Carbon $document_expiry_date
     * @property string $document_number
     * @property string $document_type
     * @property string $nationality
     * @property \Illuminate\Support\Carbon $date_of_birth
     * @property string $last_name
     * @property string $first_name
     * @property mixed $user_id
     * @property int $id
     * @property-read mixed $full_name
     * @property-read mixed $status_label
     * @property-read mixed $status_color
     * @property-read mixed $document_type_label
     * @property-read mixed $formatted_date_of_birth
     * @property-read mixed $formatted_document_expiry
     * @property-read mixed $formatted_submitted_at
     * @property-read mixed $formatted_verified_at
     * @property-read \App\Models\User $user
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereFirstName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereLastName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereDateOfBirth($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereNationality($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereDocumentType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereDocumentNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereDocumentExpiryDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereAddressLine1($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereAddressLine2($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereCity($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereStateProvince($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC wherePostalCode($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereCountry($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC wherePhoneNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereDocumentFrontPath($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereDocumentBackPath($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereSelfiePath($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereRejectionReason($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereSubmittedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereVerifiedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC query()
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static KYC|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC clone()
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static KYC|null first(array|string $columns)
     * @method static KYC firstOrFail(array|string $columns, string|null $message)
     * @method static KYC sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<KYC>|KYC tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class KYC extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\MembershipCard
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property mixed $status
     * @property \Illuminate\Support\Carbon $expires_at
     * @property \Illuminate\Support\Carbon $issued_at
     * @property string|null $qr_code_path
     * @property string $card_number
     * @property mixed $membership_tier_id
     * @property mixed $user_id
     * @property int $id
     * @property-read mixed $qr_code_url
     * @property-read mixed $is_active
     * @property-read mixed $is_expired
     * @property-read mixed $days_until_expiry
     * @property-read mixed $status_badge
     * @property-read \App\Models\User $user
     * @property-read \App\Models\MembershipTier $membershipTier
     * @property-read \App\Models\MembershipPurchase $purchase
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereMembershipTierId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereCardNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereQrCodePath($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereIssuedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereExpiresAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard query()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard active() {@see App\Models\MembershipCard::scopeActive()}
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard expired() {@see App\Models\MembershipCard::scopeExpired()}
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static MembershipCard|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard clone()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static MembershipCard|null first(array|string $columns)
     * @method static MembershipCard firstOrFail(array|string $columns, string|null $message)
     * @method static MembershipCard sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipCard>|MembershipCard tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class MembershipCard extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\MembershipPurchase
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property \Illuminate\Support\Carbon|null $purchased_at
     * @property string|null $notes
     * @property mixed $status
     * @property mixed $payment_method
     * @property string $currency
     * @property float $amount
     * @property string $transaction_id
     * @property mixed $membership_card_id
     * @property mixed $membership_tier_id
     * @property mixed $user_id
     * @property int $id
     * @property-read mixed $formatted_amount
     * @property-read mixed $status_badge
     * @property-read mixed $payment_method_label
     * @property-read \App\Models\User $user
     * @property-read \App\Models\MembershipTier $membershipTier
     * @property-read \App\Models\MembershipCard $membershipCard
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereMembershipTierId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereMembershipCardId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereTransactionId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereCurrency($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase wherePaymentMethod($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase wherePurchasedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase query()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase completed() {@see App\Models\MembershipPurchase::scopeCompleted()}
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase pending() {@see App\Models\MembershipPurchase::scopePending()}
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static MembershipPurchase|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase clone()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static MembershipPurchase|null first(array|string $columns)
     * @method static MembershipPurchase firstOrFail(array|string $columns, string|null $message)
     * @method static MembershipPurchase sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipPurchase>|MembershipPurchase tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class MembershipPurchase extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\MembershipTier
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property integer $sort_order
     * @property boolean $is_active
     * @property boolean $priority_support
     * @property integer $giveaway_entry_multiplier
     * @property float $investment_bonus_percentage
     * @property float $car_discount_percentage
     * @property array|null $benefits
     * @property integer $duration_days
     * @property string $currency
     * @property float $price
     * @property string|null $description
     * @property string $slug
     * @property string $name
     * @property int $id
     * @property-read mixed $formatted_price
     * @property-read mixed $duration_in_months
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\MembershipCard> $cards
     * @property-read int|null $cards_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\MembershipPurchase> $purchases
     * @property-read int|null $purchases_count
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereSlug($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier wherePrice($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereCurrency($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereDurationDays($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereBenefits($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereCarDiscountPercentage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereInvestmentBonusPercentage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereGiveawayEntryMultiplier($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier wherePrioritySupport($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereIsActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereSortOrder($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier query()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier active() {@see App\Models\MembershipTier::scopeActive()}
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier ordered() {@see App\Models\MembershipTier::scopeOrdered()}
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static MembershipTier|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier clone()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static MembershipTier|null first(array|string $columns)
     * @method static MembershipTier firstOrFail(array|string $columns, string|null $message)
     * @method static MembershipTier sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<MembershipTier>|MembershipTier tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class MembershipTier extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Notification
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property \Illuminate\Support\Carbon|null $read_at
     * @property boolean $is_read
     * @property array|null $data
     * @property string $message
     * @property string $title
     * @property string $type
     * @property mixed $user_id
     * @property int $id
     * @property-read mixed $formatted_time
     * @property-read mixed $icon
     * @property-read mixed $color
     * @property-read \App\Models\User $user
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereTitle($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereMessage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereData($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereIsRead($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereReadAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification query()
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification unread() {@see App\Models\Notification::scopeUnread()}
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification read() {@see App\Models\Notification::scopeRead()}
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Notification|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Notification|null first(array|string $columns)
     * @method static Notification firstOrFail(array|string $columns, string|null $message)
     * @method static Notification sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Notification>|Notification tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Notification extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\PaymentMethod
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $allow_withdraw
     * @property boolean $allow_deposit
     * @property boolean $is_active
     * @property float|null $network_fee
     * @property string|null $crypto_symbol
     * @property string|null $wallet_address
     * @property string|null $barcode
     * @property string|null $logo
     * @property string|null $details
     * @property mixed $type
     * @property string $name
     * @property int $id
     * @property-read mixed $logo_url
     * @property-read mixed $barcode_data
     * @property-read mixed $formatted_network_fee
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Purchase> $purchases
     * @property-read int|null $purchases_count
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereDetails($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereLogo($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereBarcode($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereWalletAddress($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereCryptoSymbol($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereNetworkFee($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereIsActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereAllowDeposit($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereAllowWithdraw($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod query()
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod active() {@see App\Models\PaymentMethod::scopeActive()}
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod traditional() {@see App\Models\PaymentMethod::scopeTraditional()}
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod cryptocurrency() {@see App\Models\PaymentMethod::scopeCryptocurrency()}
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod allowDeposit() {@see App\Models\PaymentMethod::scopeAllowDeposit()}
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod allowWithdraw() {@see App\Models\PaymentMethod::scopeAllowWithdraw()}
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static PaymentMethod|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod clone()
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static PaymentMethod|null first(array|string $columns)
     * @method static PaymentMethod firstOrFail(array|string $columns, string|null $message)
     * @method static PaymentMethod sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class PaymentMethod extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Purchase
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property \Illuminate\Support\Carbon|null $purchased_at
     * @property mixed $status
     * @property float|null $exchange_rate
     * @property string|null $crypto_currency
     * @property float|null $crypto_amount
     * @property string|null $transaction_hash
     * @property string|null $tax_id
     * @property string|null $company_name
     * @property string|null $billing_country
     * @property string|null $billing_postal_code
     * @property string|null $billing_state
     * @property string|null $billing_city
     * @property string|null $billing_address
     * @property string|null $billing_phone
     * @property string|null $billing_email
     * @property string|null $billing_name
     * @property float $amount
     * @property mixed $payment_method_id
     * @property mixed $car_id
     * @property mixed $user_id
     * @property int $id
     * @property-read mixed $formatted_amount
     * @property-read mixed $formatted_crypto_amount
     * @property-read mixed $full_billing_address
     * @property-read mixed $status_badge
     * @property-read \App\Models\User $user
     * @property-read \App\Models\Car $car
     * @property-read \App\Models\PaymentMethod $paymentMethod
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereCarId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase wherePaymentMethodId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereBillingName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereBillingEmail($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereBillingPhone($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereBillingAddress($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereBillingCity($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereBillingState($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereBillingPostalCode($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereBillingCountry($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereCompanyName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereTaxId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereTransactionHash($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereCryptoAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereCryptoCurrency($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereExchangeRate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase wherePurchasedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase query()
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Purchase|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Purchase|null first(array|string $columns)
     * @method static Purchase firstOrFail(array|string $columns, string|null $message)
     * @method static Purchase sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Purchase>|Purchase tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Purchase extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Setting
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $is_public
     * @property string|null $description
     * @property string $label
     * @property string $group
     * @property string $type
     * @property string|null $value
     * @property string $key
     * @property int $id
     * @property-read mixed $formatted_value
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereKey($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereValue($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereGroup($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereLabel($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereIsPublic($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting query()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Setting|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int increment(string $column, float|int $amount)
     * @method static int incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int decrement(string $column, float|int $amount)
     * @method static int decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Setting|null first(array|string $columns)
     * @method static Setting firstOrFail(array|string $columns, string|null $message)
     * @method static Setting sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Setting extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Stock
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property \Illuminate\Support\Carbon|null $volume_updated_at
     * @property \Illuminate\Support\Carbon|null $last_updated
     * @property boolean $is_featured
     * @property boolean $is_active
     * @property float|null $fifty_two_week_low
     * @property float|null $fifty_two_week_high
     * @property float|null $dividend_yield
     * @property float|null $pe_ratio
     * @property float|null $market_cap
     * @property float|null $open
     * @property float|null $low
     * @property float|null $high
     * @property integer|null $volume
     * @property float|null $change_percentage
     * @property float|null $change_amount
     * @property float|null $previous_close
     * @property float $current_price
     * @property string|null $logo_url
     * @property string|null $industry
     * @property string|null $sector
     * @property string $company_name
     * @property string $symbol
     * @property int $id
     * @property-read mixed $formatted_current_price
     * @property-read mixed $formatted_change_amount
     * @property-read mixed $formatted_change_percentage
     * @property-read mixed $change_color
     * @property-read mixed $formatted_volume
     * @property-read mixed $formatted_market_cap
     * @property-read mixed $formatted_pe_ratio
     * @property-read mixed $formatted_dividend_yield
     * @property-read mixed $formatted_fifty_two_week_high
     * @property-read mixed $formatted_fifty_two_week_low
     * @property-read mixed $formatted_last_updated
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\StockHolding> $holdings
     * @property-read int|null $holdings_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\StockTransaction> $transactions
     * @property-read int|null $transactions_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\StockWatchlist> $watchlists
     * @property-read int|null $watchlists_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\StockPriceHistory> $priceHistory
     * @property-read int|null $priceHistory_count
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereSymbol($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereCompanyName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereSector($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereIndustry($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereLogoUrl($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereCurrentPrice($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock wherePreviousClose($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereChangeAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereChangePercentage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereVolume($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereHigh($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereLow($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereOpen($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereMarketCap($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock wherePeRatio($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereDividendYield($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereFiftyTwoWeekHigh($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereFiftyTwoWeekLow($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereIsActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereIsFeatured($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereLastUpdated($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereVolumeUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock query()
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock active() {@see App\Models\Stock::scopeActive()}
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock featured() {@see App\Models\Stock::scopeFeatured()}
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock bySector(mixed $sector) {@see App\Models\Stock::scopeBySector()}
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock byIndustry(mixed $industry) {@see App\Models\Stock::scopeByIndustry()}
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock gainers() {@see App\Models\Stock::scopeGainers()}
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock losers() {@see App\Models\Stock::scopeLosers()}
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock mostActive() {@see App\Models\Stock::scopeMostActive()}
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock bySymbol(mixed $symbol) {@see App\Models\Stock::scopeBySymbol()}
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock byCompanyName(mixed $name) {@see App\Models\Stock::scopeByCompanyName()}
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Stock>|Stock limit(int $value)
     * @method static \Illuminate\Dat