import defaultTheme from 'tailwindcss/defaultTheme';
import forms from '@tailwindcss/forms';
import typography from '@tailwindcss/typography';
import aspectRatio from '@tailwindcss/aspect-ratio';
import tailwindAnimate from 'tailwindcss-animate';

/** @type {import('tailwindcss').Config} */
export default {
    darkMode: ["class"],
    content: ["./vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php", "./storage/framework/views/*.php", "./resources/views/**/*.blade.php", "*.{js,ts,jsx,tsx,mdx}", "app/**/*.{ts,tsx}", "components/**/*.{ts,tsx}"],

    theme: {
        extend: {
            fontFamily: {
                sans: ['Inter', 'Figtree', ...defaultTheme.fontFamily.sans],
            },
            colors: {
                border: "hsl(var(--border))",
                input: "hsl(var(--input))",
                ring: "hsl(var(--ring))",
                background: "hsl(var(--background))",
                foreground: "hsl(var(--foreground))",
                primary: {
                    DEFAULT: "hsl(var(--primary))",
                    foreground: "hsl(var(--primary-foreground))",
                },
                secondary: {
                    DEFAULT: "hsl(var(--secondary))",
                    foreground: "hsl(var(--secondary-foreground))",
                },
                destructive: {
                    DEFAULT: "hsl(var(--destructive))",
                    foreground: "hsl(var(--destructive-foreground))",
                },
                muted: {
                    DEFAULT: "hsl(var(--muted))",
                    foreground: "hsl(var(--muted-foreground))",
                },
                accent: {
                    DEFAULT: "hsl(var(--accent))",
                    foreground: "hsl(var(--accent-foreground))",
                },
                popover: {
                    DEFAULT: "hsl(var(--popover))",
                    foreground: "hsl(var(--popover-foreground))",
                },
                card: {
                    DEFAULT: "hsl(var(--card))",
                    foreground: "hsl(var(--card-foreground))",
                },
                // Tesla Red Color System - Remapping blue to Tesla red
                blue: {
                    50: '#fef2f2',     // Very light red
                    100: '#fee2e2',    // Light red
                    200: '#fecaca',    // Lighter red
                    300: '#fca5a5',    // Light-medium red
                    400: '#f87171',    // Medium red
                    500: '#C8102E',    // Tesla Red (main)
                    600: '#A00D25',    // Darker Tesla Red
                    700: '#7D0A1D',    // Dark red
                    800: '#5A0716',    // Very dark red
                    900: '#3D0510',    // Almost black red
                    950: '#1F030A',    // Near black red
                },
                'tesla': {
                    50: '#fef2f2',
                    100: '#fee2e2',
                    200: '#fecaca',
                    300: '#fca5a5',
                    400: '#f87171',
                    500: '#C8102E',    // Tesla Red
                    600: '#A00D25',
                    700: '#7D0A1D',
                    800: '#5A0716',
                    900: '#3D0510',
                    950: '#1F030A',
                },
                'tesla-blue': '#C8102E',  // Remapped to Tesla red
                'tesla-red': '#C8102E',   // Tesla Red
                // Custom Dark Mode Colors
                'dark-bg': '#0D1117',
                'dark-card': '#161B22',
                'dark-accent': '#C8102E',  // Changed to Tesla red
                'dark-success': '#2EA043',
                'dark-danger': '#F85149',
                'dark-text': '#8B949E',
            },
            animation: {
                'fade-in': 'fadeIn 0.5s ease-in-out',
                'slide-up': 'slideUp 0.3s ease-out',
                'slide-down': 'slideDown 0.3s ease-out',
            },
            keyframes: {
                fadeIn: {
                    '0%': { opacity: '0' },
                    '100%': { opacity: '1' },
                },
                slideUp: {
                    '0%': { transform: 'translateY(10px)', opacity: '0' },
                    '100%': { transform: 'translateY(0)', opacity: '1' },
                },
                slideDown: {
                    '0%': { transform: 'translateY(-10px)', opacity: '0' },
                    '100%': { transform: 'translateY(0)', opacity: '1' },
                },
            },
            screens: {
                'xs': '475px',
            },
            borderRadius: {
                lg: "var(--radius)",
                md: "calc(var(--radius) - 2px)",
                sm: "calc(var(--radius) - 4px)",
            },
        },
    },

    plugins: [
        forms,
        typography,
        aspectRatio,
        tailwindAnimate,
    ],
};
