<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title><?php echo e(isset($title) ? $title . ' - ' . site_name() : site_name()); ?></title>

        <!-- Favicon -->
        <?php if(site_favicon()): ?>
            <link rel="icon" type="image/x-icon" href="<?php echo e(site_favicon()); ?>">
        <?php endif; ?>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=inter:300,400,500,600,700&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    
    <script>
        // Initialize theme based on system preference
        function initTheme() {
            const savedTheme = localStorage.getItem('theme');
            const prefersDark = window.matchMedia('(prefers-color-scheme: dark)').matches;
            
            if (savedTheme) {
                // Use saved preference
                if (savedTheme === 'dark') {
                    document.documentElement.classList.add('dark');
                } else {
                    document.documentElement.classList.remove('dark');
                }
            } else {
                // Use system preference
                if (prefersDark) {
                    document.documentElement.classList.add('dark');
                } else {
                    document.documentElement.classList.remove('dark');
                }
            }
        }
        initTheme();
        
        // Listen for system theme changes
        window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', (e) => {
            if (!localStorage.getItem('theme')) {
                if (e.matches) {
                    document.documentElement.classList.add('dark');
                } else {
                    document.documentElement.classList.remove('dark');
                }
            }
        });
    </script>
</head>
<body class="font-sans antialiased transition-colors duration-200" style="background-color: #fef2f2; color: #1f2937;">
    <div class="min-h-screen flex flex-col">
        <!-- Enhanced Navigation -->
        <nav class="border-b shadow-sm transition-colors duration-200" style="background-color: white; border-color: #fecaca;">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between items-center h-14">
                    <!-- Logo -->
                    <div class="flex items-center">
                        <a href="<?php echo e(route('home')); ?>" class="flex items-center group">
                            <?php if(site_logo()): ?>
                                <img src="<?php echo e(site_logo()); ?>" alt="<?php echo e(site_name()); ?>" class="h-6 w-auto group-hover:opacity-70 transition-opacity duration-200">
                            <?php else: ?>
                                <span class="text-lg font-bold group-hover:opacity-70 transition-opacity duration-200" style="color: #C8102E;"><?php echo e(site_name()); ?></span>
                            <?php endif; ?>
                        </a>
                    </div>

                    <!-- Right Side Links -->
                    <div class="flex items-center space-x-4 md:space-x-6">
                        <a href="<?php echo e(route('home')); ?>" class="hidden md:block text-xs font-medium transition-colors duration-200" style="color: #7D0A1D;" onmouseover="this.style.color='#C8102E'" onmouseout="this.style.color='#7D0A1D'">Home</a>
                        <a href="<?php echo e(route('cars.browse')); ?>" class="hidden md:block text-xs font-medium transition-colors duration-200" style="color: #7D0A1D;" onmouseover="this.style.color='#C8102E'" onmouseout="this.style.color='#7D0A1D'">Inventory</a>
                        <?php if(Route::has('login')): ?>
                            <?php if(auth()->guard()->check()): ?>
                                <a href="<?php echo e(route('dashboard')); ?>" class="hidden md:block text-xs font-medium transition-colors duration-200" style="color: #7D0A1D;" onmouseover="this.style.color='#C8102E'" onmouseout="this.style.color='#7D0A1D'">Dashboard</a>
                            <?php else: ?>
                                <a href="<?php echo e(route('login')); ?>" class="hidden sm:block text-xs font-medium transition-colors duration-200" style="color: #7D0A1D;" onmouseover="this.style.color='#C8102E'" onmouseout="this.style.color='#7D0A1D'">Sign In</a>
                                <?php if(Route::has('register')): ?>
                                    <a href="<?php echo e(route('register')); ?>" class="hidden sm:block text-xs font-medium transition-colors duration-200" style="color: #7D0A1D;" onmouseover="this.style.color='#C8102E'" onmouseout="this.style.color='#7D0A1D'">Register</a>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endif; ?>
                        
                        <!-- Theme Toggle (Visible on all screen sizes) -->
                        <button id="theme-toggle" onclick="toggleTheme()" class="p-2 rounded-lg transition-colors duration-500" style="color: #7D0A1D;" onmouseover="this.style.backgroundColor='#fef2f2'" onmouseout="this.style.backgroundColor='transparent'" aria-label="Toggle theme">
                            <i data-lucide="sun" class="w-4 h-4 dark:hidden"></i>
                            <i data-lucide="moon" class="w-4 h-4 hidden dark:block"></i>
                        </button>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Enhanced Main Content -->
        <main class="flex-grow flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
            <div class="w-full max-w-sm">
                <?php echo e($slot); ?>

            </div>
        </main>

        <!-- Enhanced Footer -->
        <footer class="text-white py-6 transition-colors duration-200" style="background-color: #C8102E;">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex flex-col md:flex-row justify-between items-center">
                    <div class="mb-3 md:mb-0">
                        <p class="text-xs" style="color: #fee2e2;">&copy; <?php echo e(date('Y')); ?> <?php echo e(site_name()); ?>. All rights reserved.</p>
                    </div>
                    <div class="flex space-x-6">
                        <a href="<?php echo e(route('privacy')); ?>" class="text-xs transition-colors duration-200" style="color: #fee2e2;" onmouseover="this.style.color='white'" onmouseout="this.style.color='#fee2e2'">Privacy Policy</a>
                        <a href="<?php echo e(route('terms')); ?>" class="text-xs transition-colors duration-200" style="color: #fee2e2;" onmouseover="this.style.color='white'" onmouseout="this.style.color='#fee2e2'">Terms of Service</a>
                        <a href="<?php echo e(route('contact')); ?>" class="text-xs transition-colors duration-200" style="color: #fee2e2;" onmouseover="this.style.color='white'" onmouseout="this.style.color='#fee2e2'">Contact</a>
                    </div>
                </div>
            </div>
        </footer>
    </div>
    
    <script>
        // Initialize Lucide icons when DOM is ready
        document.addEventListener('DOMContentLoaded', function() {
            if (typeof lucide !== 'undefined') {
                lucide.createIcons();
            }
        });
        
        function toggleTheme() {
            const html = document.documentElement;
            const isDark = html.classList.contains('dark');
            
            if (isDark) {
                html.classList.remove('dark');
                localStorage.setItem('theme', 'light');
            } else {
                html.classList.add('dark');
                localStorage.setItem('theme', 'dark');
            }
            
            // Reinitialize Lucide icons
            setTimeout(() => {
                if (typeof lucide !== 'undefined') {
                    lucide.createIcons();
                }
            }, 100);
        }
    </script>
</body>
</html>
<?php /**PATH /home/sbrbot/tesla.sbrbot.trading/resources/views/layouts/guest.blade.php ENDPATH**/ ?>