<x-user-layout>
    <x-slot name="header">
        Top Losers
    </x-slot>

    <div class="max-w-7xl mx-auto">
        <!-- Enhanced Header -->
        <div class="bg-gradient-to-br from-red-600 via-red-700 to-red-800 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 right-0 w-48 h-48 bg-white rounded-full -translate-y-24 translate-x-24"></div>
                <div class="absolute bottom-0 left-0 w-24 h-24 bg-white rounded-full translate-y-12 -translate-x-12"></div>
            </div>
            
            <div class="relative z-10">
                <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                    <div class="mb-4 lg:mb-0 lg:flex-1">
                        <h1 class="text-xl font-light mb-1">Top Losers</h1>
                        <p class="text-red-200 text-sm">Stocks with the highest percentage losses today</p>
                    </div>
                    
                    <!-- Enhanced Stats Card -->
                    <div class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-80">
                        <div class="flex items-center justify-between mb-3">
                            <div>
                                <p class="text-xs text-red-200 mb-1">Top Loser</p>
                                <p class="text-lg font-light">{{ $stocks->first() ? number_format($stocks->first()->change_percentage, 2) : '0.00' }}%</p>
                            </div>
                            <div class="w-10 h-10 flex items-center justify-center">
                                <i data-lucide="trending-down" class="w-5 h-5 text-white"></i>
                            </div>
                        </div>
                        <div class="flex space-x-4 text-xs">
                            <div class="flex-1 text-center">
                                <p class="text-red-200">Average</p>
                                <p class="text-white font-medium">{{ number_format($stocks->avg('change_percentage'), 2) }}%</p>
                            </div>
                            <div class="flex-1 text-center">
                                <p class="text-red-200">Count</p>
                                <p class="text-white font-medium">{{ $stocks->count() }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Losers List -->
        <div class="bg-white dark:bg-blue-700 rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-100 dark:border-blue-600">
                <div class="flex items-center justify-between">
                    <div>
                        <h3 class="text-lg font-light text-black dark:text-white mb-1">Top Losers</h3>
                        <p class="text-xs text-gray-500 dark:text-blue-200">Stocks with the highest percentage losses</p>
                    </div>
                </div>
            </div>
            
            @if($stocks->count() > 0)
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Rank</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Stock</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Price</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Change</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Volume</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Market Cap</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white dark:bg-blue-700 divide-y divide-gray-100 dark:divide-blue-600">
                            @foreach($stocks as $index => $stock)
                            <tr class="hover:bg-gray-50 transition-colors duration-200">
                                <td class="px-6 py-4">
                                    <div class="flex items-center">
                                        @if($index < 3)
                                            <div class="w-6 h-6 bg-red-100 rounded-full flex items-center justify-center mr-2">
                                                <span class="text-xs font-medium text-red-800">{{ $index + 1 }}</span>
                                            </div>
                                        @else
                                            <span class="text-xs font-medium text-gray-500 dark:text-blue-200">{{ $index + 1 }}</span>
                                        @endif
                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="flex items-center">
                                        <div class="flex-shrink-0 w-8 h-8 rounded-lg overflow-hidden">
                                            @if($stock->logo_url)
                                                <img src="{{ $stock->logo_url }}" alt="{{ $stock->company_name }}" class="w-8 h-8 object-cover">
                                            @else
                                                <div class="w-8 h-8 bg-red-100 rounded-lg flex items-center justify-center">
                                                    <i data-lucide="trending-down" class="w-4 h-4 text-red-600"></i>
                                                </div>
                                            @endif
                                        </div>
                                        <div class="ml-3">
                                            <div class="text-sm font-medium text-black">{{ $stock->symbol }}</div>
                                            <div class="text-xs text-gray-500 dark:text-blue-200">{{ $stock->company_name }}</div>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-sm text-black">{{ $stock->formatted_current_price }}</div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-sm text-red-600">
                                        {{ $stock->formatted_change_amount }}
                                    </div>
                                    <div class="text-xs text-red-600">
                                        {{ $stock->formatted_change_percentage }}
                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-sm text-black">{{ $stock->formatted_volume }}</div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-sm text-black">{{ $stock->formatted_market_cap }}</div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="flex space-x-2">
                                        <a href="{{ route('stocks.show', $stock) }}" class="text-xs text-blue-600 hover:text-blue-800 transition-colors duration-200">
                                            View
                                        </a>
                                        <a href="{{ route('trading.buy', $stock) }}" class="text-xs text-green-600 hover:text-green-800 transition-colors duration-200">
                                            Buy
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="px-6 py-4 border-t border-gray-100 dark:border-blue-600">
                    {{ $stocks->links() }}
                </div>
            @else
                <div class="text-center py-12">
                    <div class="w-16 h-16 bg-gray-100 dark:bg-blue-600 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i data-lucide="trending-down" class="w-8 h-8 text-gray-400 dark:text-blue-200"></i>
                    </div>
                    <h3 class="text-lg font-light text-black dark:text-white mb-2">No losers found</h3>
                    <p class="text-gray-600 text-sm mb-4">No stocks with negative losses at the moment</p>
                    <a href="{{ route('stocks.index') }}" class="inline-flex items-center px-4 py-2 bg-black dark:bg-white text-white dark:text-blue-900 text-sm font-medium rounded-lg hover:bg-gray-800 dark:hover:bg-blue-50 transition-colors duration-200">
                        <i data-lucide="bar-chart-3" class="w-4 h-4 mr-2"></i>
                        Browse All Stocks
                    </a>
                </div>
            @endif
        </div>
    </div>
</x-user-layout> 
