<x-user-layout>
    <x-slot name="header">
        Payment Pending
    </x-slot>

    <div class="max-w-3xl mx-auto">
        <div class="bg-white dark:bg-blue-700 rounded-xl p-8 border border-gray-100 dark:border-blue-600">
            <!-- Status Icon -->
            <div class="text-center mb-6">
                <div class="inline-flex items-center justify-center w-16 h-16 bg-orange-100 dark:bg-orange-900/20 rounded-full mb-4">
                    <svg class="w-8 h-8 text-orange-600 dark:text-orange-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <h1 class="text-2xl font-light text-black dark:text-white mb-2">Payment Pending</h1>
                <p class="text-gray-600 dark:text-blue-100">Please complete your payment to activate your membership</p>
            </div>

            <!-- Payment Instruction Banner -->
            <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4 mb-6">
                <div class="flex items-start">
                    <svg class="w-5 h-5 text-blue-600 dark:text-blue-400 mt-0.5 mr-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <div class="flex-1">
                        <p class="text-sm font-medium text-blue-900 dark:text-blue-200">Payment Required</p>
                        <p class="text-sm text-blue-700 dark:text-blue-300 mt-1">
                            Please make a deposit of <strong>{{ $membershipPurchase->formatted_amount }}</strong> to your wallet. 
                            Your membership will be activated once your payment is confirmed by our team.
                        </p>
                    </div>
                </div>
            </div>

            <!-- Purchase Details -->
            <div class="bg-gray-50 dark:bg-blue-800 rounded-lg p-6 mb-6 border border-gray-200 dark:border-blue-600">
                <h3 class="font-medium text-black dark:text-white mb-4">Purchase Details</h3>
                
                <div class="space-y-3">
                    <div class="flex justify-between">
                        <span class="text-gray-600 dark:text-blue-100">Transaction ID</span>
                        <span class="font-medium text-black dark:text-white">{{ $membershipPurchase->transaction_id }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600 dark:text-blue-100">Membership Tier</span>
                        <span class="font-medium text-black dark:text-white">{{ $membershipPurchase->membershipTier->name }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600 dark:text-blue-100">Amount</span>
                        <span class="font-medium text-black dark:text-white">{{ $membershipPurchase->formatted_amount }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600 dark:text-blue-100">Payment Method</span>
                        <span class="font-medium text-black dark:text-white">{{ $membershipPurchase->payment_method_label }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600 dark:text-blue-100">Status</span>
                        <span class="inline-flex items-center px-2 py-1 text-xs font-medium rounded {{ $membershipPurchase->status_badge }}">
                            {{ ucfirst($membershipPurchase->status) }}
                        </span>
                    </div>
                </div>
            </div>

            <!-- Payment Instructions -->
            <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-6 mb-6">
                <h3 class="font-medium text-black dark:text-white mb-3">How to Complete Payment</h3>
                <ol class="list-decimal list-inside space-y-2 text-sm text-gray-700 dark:text-blue-100">
                    <li>Go to your wallet and make a deposit of <strong>{{ $membershipPurchase->formatted_amount }}</strong></li>
                    <li>Use <strong>{{ $membershipPurchase->transaction_id }}</strong> as reference (optional)</li>
                    <li>Once deposit is confirmed, admin will activate your membership</li>
                    <li>You'll receive an email when your membership card is ready</li>
                </ol>
                <div class="mt-4">
                    <a href="{{ route('wallet.index') }}" class="inline-flex items-center px-4 py-2 bg-gradient-to-r from-blue-600 to-blue-700 text-white rounded-lg hover:from-blue-700 hover:to-blue-800 text-sm font-medium transition-colors">
                        Go to Wallet →
                    </a>
                </div>
            </div>

            <!-- Actions -->
            <div class="flex justify-between items-center pt-6 border-t border-gray-200 dark:border-blue-600">
                <a href="{{ route('memberships.index') }}" class="text-gray-600 dark:text-blue-100 hover:text-black dark:hover:text-white transition-colors">
                    ← Back to Memberships
                </a>
                <a href="{{ route('wallet.index') }}" class="bg-gradient-to-r from-blue-600 to-blue-700 text-white px-6 py-2 rounded-lg hover:from-blue-700 hover:to-blue-800 text-sm font-medium transition-colors">
                    Make Deposit
                </a>
            </div>
        </div>

        <!-- Help Section -->
        <div class="mt-6 text-center">
            <p class="text-sm text-gray-600 dark:text-blue-100 mb-2">Need help with your payment?</p>
            <a href="{{ route('support.index') }}" class="text-blue-600 dark:text-blue-300 hover:text-blue-700 dark:hover:text-blue-200 text-sm font-medium">
                Contact Support →
            </a>
        </div>
    </div>
</x-user-layout>
