<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>VIP Membership Card - {{ $membershipCard->card_number }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Helvetica', 'Arial', sans-serif;
            background: linear-gradient(135deg, #fef2f2 0%, #ffffff 50%, #fef2f2 100%);
            padding: 30px 20px;
        }
        
        .card-container {
            max-width: 800px;
            margin: 0 auto;
            background: linear-gradient(135deg, #C8102E 0%, #A00D25 50%, #7D0A1D 100%);
            border-radius: 24px;
            padding: 50px 40px;
            box-shadow: 0 20px 60px rgba(200, 16, 46, 0.4), 0 0 0 1px rgba(255, 255, 255, 0.1);
            position: relative;
            overflow: hidden;
        }
        
        .card-container::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle at 30% 30%, rgba(255,255,255,0.15) 0%, transparent 50%);
            pointer-events: none;
        }
        
        .card-container::after {
            content: '';
            position: absolute;
            bottom: -100px;
            left: -100px;
            width: 300px;
            height: 300px;
            background: radial-gradient(circle, rgba(255,255,255,0.08) 0%, transparent 70%);
            pointer-events: none;
        }
        
        .header {
            text-align: center;
            margin-bottom: 35px;
            position: relative;
            z-index: 1;
        }
        
        .logo-image {
            max-width: 120px;
            max-height: 80px;
            margin: 0 auto 15px;
            display: block;
            filter: drop-shadow(0 4px 12px rgba(0, 0, 0, 0.3));
        }
        
        .logo {
            color: white;
            font-size: 36px;
            font-weight: 900;
            margin-bottom: 8px;
            letter-spacing: 3px;
            text-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
        }
        
        .subtitle {
            color: rgba(255, 255, 255, 0.95);
            font-size: 13px;
            text-transform: uppercase;
            letter-spacing: 4px;
            font-weight: 500;
        }
        
        .card-body {
            background: white;
            border-radius: 16px;
            padding: 40px 35px;
            position: relative;
            z-index: 1;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.12);
            border: 1px solid rgba(200, 16, 46, 0.08);
        }
        
        .tier-badge {
            display: inline-block;
            padding: 10px 24px;
            border-radius: 30px;
            font-size: 13px;
            font-weight: 700;
            margin-bottom: 25px;
            text-transform: uppercase;
            letter-spacing: 1.5px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            border: 2px solid rgba(255, 255, 255, 0.3);
        }
        
        .tier-bronze {
            background: linear-gradient(135deg, #cd7f32 0%, #a0522d 50%, #8b4513 100%);
            color: white;
            text-shadow: 0 1px 3px rgba(0, 0, 0, 0.3);
        }
        
        .tier-silver {
            background: linear-gradient(135deg, #e8e8e8 0%, #c0c0c0 50%, #a8a8a8 100%);
            color: #333;
            text-shadow: 0 1px 2px rgba(255, 255, 255, 0.5);
        }
        
        .tier-gold {
            background: linear-gradient(135deg, #ffd700 0%, #f4c430 50%, #d4af37 100%);
            color: #664d03;
            text-shadow: 0 1px 2px rgba(255, 255, 255, 0.5);
        }
        
        .tier-platinum {
            background: linear-gradient(135deg, #f5f5f5 0%, #e5e4e2 50%, #b0afad 100%);
            color: #2c2c2c;
            text-shadow: 0 1px 2px rgba(255, 255, 255, 0.5);
        }
        
        .member-info {
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid #f3f4f6;
        }
        
        .member-name {
            font-size: 28px;
            font-weight: 700;
            color: #C8102E;
            margin-bottom: 6px;
            letter-spacing: 0.5px;
        }
        
        .member-email {
            font-size: 14px;
            color: #6b7280;
            letter-spacing: 0.3px;
        }
        
        .card-details {
            display: table;
            width: 100%;
            margin-bottom: 25px;
            background: linear-gradient(to right, #fef2f2, #ffffff);
            border-radius: 8px;
            padding: 15px 20px;
        }
        
        .detail-row {
            display: table-row;
        }
        
        .detail-label {
            display: table-cell;
            padding: 10px 0;
            font-size: 13px;
            color: #6b7280;
            width: 40%;
            font-weight: 500;
        }
        
        .detail-value {
            display: table-cell;
            padding: 10px 0;
            font-size: 14px;
            color: #1f2937;
            font-weight: 600;
            letter-spacing: 0.3px;
        }
        
        .qr-section {
            text-align: center;
            padding: 25px 20px;
            border-top: 2px dashed #fecaca;
            background: linear-gradient(135deg, #fef2f2 0%, #ffffff 100%);
            border-radius: 12px;
            margin-top: 15px;
            box-shadow: inset 0 2px 4px rgba(0, 0, 0, 0.03);
        }
        
        .qr-code {
            margin: 15px auto;
            max-width: 150px;
            height: auto;
            padding: 10px;
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }
        
        .qr-label {
            font-size: 12px;
            color: #6b7280;
            margin-top: 12px;
            font-weight: 500;
            letter-spacing: 0.5px;
        }
        
        .benefits-section {
            margin-top: 25px;
            padding-top: 25px;
            border-top: 2px dashed #fecaca;
        }
        
        .benefits-title {
            font-size: 17px;
            font-weight: 700;
            color: #C8102E;
            margin-bottom: 18px;
            letter-spacing: 0.5px;
        }
        
        .benefit-item {
            display: flex;
            align-items: flex-start;
            margin-bottom: 12px;
            padding: 8px 12px;
            background: linear-gradient(to right, rgba(16, 185, 129, 0.05), transparent);
            border-radius: 6px;
            border-left: 3px solid #10b981;
        }
        
        .benefit-icon {
            color: #10b981;
            margin-right: 12px;
            font-size: 18px;
            line-height: 1.5;
            font-weight: bold;
        }
        
        .benefit-text {
            font-size: 13px;
            color: #374151;
            line-height: 1.6;
            letter-spacing: 0.2px;
        }
        
        .footer {
            text-align: center;
            margin-top: 35px;
            position: relative;
            z-index: 1;
            padding: 20px;
            background: rgba(255, 255, 255, 0.05);
            border-radius: 12px;
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .footer-text {
            color: rgba(255, 255, 255, 0.95);
            font-size: 12px;
            line-height: 1.8;
            letter-spacing: 0.3px;
        }
        
        .status-badge {
            display: inline-block;
            padding: 5px 14px;
            border-radius: 16px;
            font-size: 11px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
        }
        
        .status-active {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.2);
        }
        
        .status-expired {
            background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
            color: white;
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.2);
        }
    </style>
</head>
<body>
    <div class="card-container">
        <div class="header">
            @if(setting('site_logo'))
                <img src="{{ public_path('uploads/' . setting('site_logo')) }}" alt="{{ setting('site_name') }}" class="logo-image">
            @endif
            <div class="logo">{{ setting('site_name', 'TESLA INVESTMENT') }}</div>
            <div class="subtitle">VIP Membership Card</div>
        </div>
        
        <div class="card-body">
            <div class="tier-badge tier-{{ strtolower($membershipCard->membershipTier->name) }}">
                {{ $membershipCard->membershipTier->name }} Member
            </div>
            
            <div class="member-info">
                <div class="member-name">{{ $membershipCard->user->name }}</div>
                <div class="member-email">{{ $membershipCard->user->email }}</div>
            </div>
            
            <div class="card-details">
                <div class="detail-row">
                    <div class="detail-label">Card Number:</div>
                    <div class="detail-value">{{ $membershipCard->card_number }}</div>
                </div>
                <div class="detail-row">
                    <div class="detail-label">Member Since:</div>
                    <div class="detail-value">{{ $membershipCard->issued_at->format('F d, Y') }}</div>
                </div>
                <div class="detail-row">
                    <div class="detail-label">Valid Until:</div>
                    <div class="detail-value">{{ $membershipCard->expires_at->format('F d, Y') }}</div>
                </div>
                <div class="detail-row">
                    <div class="detail-label">Status:</div>
                    <div class="detail-value">
                        <span class="status-badge status-{{ $membershipCard->status }}">
                            {{ ucfirst($membershipCard->status) }}
                        </span>
                    </div>
                </div>
            </div>
            
            @if($membershipCard->qr_code_path && file_exists(public_path('uploads/' . $membershipCard->qr_code_path)))
            <div class="qr-section">
                <img src="{{ public_path('uploads/' . $membershipCard->qr_code_path) }}" alt="QR Code" class="qr-code">
                <div class="qr-label">Scan to verify membership</div>
            </div>
            @endif
            
            <div class="benefits-section">
                <div class="benefits-title">Your Membership Benefits</div>
                
                @if($membershipCard->membershipTier->discount_percentage > 0)
                <div class="benefit-item">
                    <span class="benefit-icon">✓</span>
                    <span class="benefit-text">{{ $membershipCard->membershipTier->discount_percentage }}% discount on all Tesla car purchases</span>
                </div>
                @endif
                
                @if($membershipCard->membershipTier->investment_bonus_percentage > 0)
                <div class="benefit-item">
                    <span class="benefit-icon">✓</span>
                    <span class="benefit-text">{{ $membershipCard->membershipTier->investment_bonus_percentage }}% bonus on investment returns</span>
                </div>
                @endif
                
                @if($membershipCard->membershipTier->giveaway_entry_multiplier > 1)
                <div class="benefit-item">
                    <span class="benefit-icon">✓</span>
                    <span class="benefit-text">{{ $membershipCard->membershipTier->giveaway_entry_multiplier }}x entries for all giveaways</span>
                </div>
                @endif
                
                @if($membershipCard->membershipTier->priority_support)
                <div class="benefit-item">
                    <span class="benefit-icon">✓</span>
                    <span class="benefit-text">Priority customer support and assistance</span>
                </div>
                @endif
                
                @if($membershipCard->membershipTier->benefits && count($membershipCard->membershipTier->benefits) > 0)
                    @foreach($membershipCard->membershipTier->benefits as $benefit)
                    <div class="benefit-item">
                        <span class="benefit-icon">✓</span>
                        <span class="benefit-text">{{ $benefit }}</span>
                    </div>
                    @endforeach
                @endif
            </div>
        </div>
        
        <div class="footer">
            <div class="footer-text">
                Thank you for being a valued VIP member.<br>
                For support, visit {{ setting('site_url', url('/')) }} or contact {{ setting('site_email', 'support@tesla.com') }}
            </div>
        </div>
    </div>
</body>
</html>
