<x-user-layout>
    <x-slot name="header">
        VIP Membership
    </x-slot>

    <div class="max-w-7xl mx-auto">
        <!-- Current Membership Status -->
        @if($activeMembership)
        <div class="bg-gradient-to-br from-blue-600 via-blue-700 to-blue-800 dark:from-blue-700 dark:via-blue-800 dark:to-blue-900 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 right-0 w-48 h-48 bg-white rounded-full -translate-y-24 translate-x-24"></div>
            </div>
            
            <div class="relative z-10">
                <h2 class="text-xl font-light mb-4">Your Active Membership</h2>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <div class="text-blue-100 dark:text-blue-200 text-sm mb-1">Tier</div>
                        <div class="text-2xl font-light">{{ $activeMembership->membershipTier->name }}</div>
                    </div>
                    <div>
                        <div class="text-blue-100 dark:text-blue-200 text-sm mb-1">Expires On</div>
                        <div class="text-lg font-light">{{ $activeMembership->expires_at->format('M d, Y') }}</div>
                        <div class="text-xs text-blue-200">{{ $activeMembership->days_until_expiry }} days remaining</div>
                    </div>
                    <div class="text-right">
                        <a href="{{ route('memberships.card') }}" class="inline-block bg-white text-blue-600 px-4 py-2 rounded-lg hover:bg-blue-50 text-sm font-medium transition-colors">
                            View Card
                        </a>
                    </div>
                </div>
            </div>
        </div>
        @else
        <div class="bg-gradient-to-br from-blue-600 via-blue-700 to-blue-800 dark:from-blue-700 dark:via-blue-800 dark:to-blue-900 rounded-2xl p-6 mb-6 text-white text-center relative overflow-hidden">
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 right-0 w-48 h-48 bg-white rounded-full -translate-y-24 translate-x-24"></div>
            </div>
            
            <div class="relative z-10">
                <h2 class="text-xl font-light mb-2">Unlock Exclusive Tesla Benefits</h2>
                <p class="text-blue-100 text-sm">Choose a VIP membership tier and enjoy special perks, discounts, and rewards</p>
            </div>
        </div>
        @endif

        <!-- Membership Tiers -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
            @foreach($tiers as $tier)
            <div class="bg-white dark:bg-blue-700 rounded-xl p-6 border border-gray-100 dark:border-blue-600 hover:shadow-lg transition-all duration-300 group flex flex-col">
                <div class="text-center mb-4">
                    <h3 class="text-xl font-light text-black dark:text-white mb-2">{{ $tier->name }}</h3>
                    <div class="text-3xl font-light text-black dark:text-white mb-1">{{ $tier->formatted_price }}</div>
                    <div class="text-xs text-gray-500 dark:text-blue-100">{{ $tier->duration_in_months }} months</div>
                </div>

                @if($tier->description)
                <p class="text-sm text-gray-600 dark:text-blue-100 mb-4 text-center">{{ $tier->description }}</p>
                @endif

                <div class="space-y-2 mb-6 flex-grow">
                    @if($tier->car_discount_percentage > 0)
                    <div class="flex items-start text-sm">
                        <svg class="w-4 h-4 text-green-600 dark:text-green-400 mt-0.5 mr-2 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span class="text-gray-700 dark:text-blue-100">{{ $tier->car_discount_percentage }}% off car purchases</span>
                    </div>
                    @endif

                    @if($tier->investment_bonus_percentage > 0)
                    <div class="flex items-start text-sm">
                        <svg class="w-4 h-4 text-green-600 dark:text-green-400 mt-0.5 mr-2 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span class="text-gray-700 dark:text-blue-100">{{ $tier->investment_bonus_percentage }}% investment bonus</span>
                    </div>
                    @endif

                    @if($tier->giveaway_entry_multiplier > 1)
                    <div class="flex items-start text-sm">
                        <svg class="w-4 h-4 text-green-600 dark:text-green-400 mt-0.5 mr-2 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span class="text-gray-700 dark:text-blue-100">{{ $tier->giveaway_entry_multiplier }}x giveaway entries</span>
                    </div>
                    @endif

                    @if($tier->priority_support)
                    <div class="flex items-start text-sm">
                        <svg class="w-4 h-4 text-green-600 dark:text-green-400 mt-0.5 mr-2 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                        </svg>
                        <span class="text-gray-700 dark:text-blue-100">Priority customer support</span>
                    </div>
                    @endif

                    @if($tier->benefits && count($tier->benefits) > 0)
                        @foreach($tier->benefits as $benefit)
                        <div class="flex items-start text-sm">
                            <svg class="w-4 h-4 text-green-600 dark:text-green-400 mt-0.5 mr-2 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                            </svg>
                            <span class="text-gray-700 dark:text-blue-100">{{ $benefit }}</span>
                        </div>
                        @endforeach
                    @endif
                </div>

                <div class="mt-auto pt-4">
                @if(!$activeMembership)
                {{-- No active membership - show purchase button --}}
                <form action="{{ route('memberships.purchase', $tier) }}" method="POST">
                    @csrf
                    <button type="submit" class="w-full bg-gradient-to-r from-blue-600 to-blue-700 text-white py-3 px-4 rounded-lg hover:from-blue-700 hover:to-blue-800 transition-colors text-sm font-semibold shadow-md">
                        Purchase Now
                    </button>
                </form>
                @elseif($activeMembership->membershipTier->id === $tier->id)
                {{-- Same tier - show renew button --}}
                <form action="{{ route('memberships.purchase', $tier) }}" method="POST">
                    @csrf
                    <button type="submit" class="w-full bg-gradient-to-r from-green-500 to-green-800 text-white py-3 px-4 rounded-lg hover:from-green-700 hover:to-green-800 transition-colors text-sm font-semibold shadow-md flex items-center justify-center">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                        </svg>
                        Renew / Extend
                    </button>
                </form>
                @elseif($tier->order < $activeMembership->membershipTier->order || $tier->price > $activeMembership->membershipTier->price)
                {{-- Higher tier - show upgrade button --}}
                <form action="{{ route('memberships.purchase', $tier) }}" method="POST">
                    @csrf
                    <button type="submit" class="w-full bg-gradient-to-r from-red-600 to-red-900 text-white py-3 px-4 rounded-lg hover:from-red-700 hover:to-red-800 transition-colors text-sm font-semibold shadow-md flex items-center justify-center">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                        </svg>
                        Upgrade Now
                    </button>
                </form>
                @else
                {{-- Lower tier - disabled --}}
                <button disabled class="w-full bg-gray-300 text-gray-600 py-3 px-4 rounded-lg text-sm font-semibold cursor-not-allowed opacity-60">
                    Cannot Downgrade
                </button>
                @endif
                </div>
            </div>
            @endforeach
        </div>
    </div>
</x-user-layout>
