<x-user-layout>
    <x-slot name="header">
        My Membership Card
    </x-slot>

    <div class="max-w-4xl mx-auto">
        @if($activeCard)
        <!-- Active Membership Card -->
        <div class="bg-gradient-to-br from-blue-600 via-blue-700 to-blue-800 dark:from-blue-700 dark:via-blue-800 dark:to-blue-900 rounded-2xl p-8 mb-6 text-white relative overflow-hidden shadow-2xl">
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 right-0 w-64 h-64 bg-white rounded-full -translate-y-32 translate-x-32"></div>
                <div class="absolute bottom-0 left-0 w-48 h-48 bg-white rounded-full translate-y-24 -translate-x-24"></div>
            </div>
            
            <div class="relative z-10">
                <div class="flex justify-between items-start mb-6">
                    <div>
                        <div class="text-sm text-blue-100 dark:text-blue-200 mb-1">Tesla VIP Membership</div>
                        <div class="text-3xl font-light">{{ $activeCard->membershipTier->name }}</div>
                    </div>
                    @if($activeCard->qr_code_url)
                    <div class="bg-white p-2 rounded-lg">
                        <img src="{{ $activeCard->qr_code_url }}" alt="QR Code" class="w-20 h-20">
                    </div>
                    @endif
                </div>

                <div class="grid grid-cols-2 gap-6 mb-6">
                    <div>
                        <div class="text-xs text-blue-100 dark:text-blue-200 mb-1">Card Number</div>
                        <div class="text-lg font-medium tracking-wider">{{ $activeCard->card_number }}</div>
                    </div>
                    <div>
                        <div class="text-xs text-blue-100 dark:text-blue-200 mb-1">Member</div>
                        <div class="text-lg font-medium">{{ auth()->user()->name }}</div>
                    </div>
                    <div>
                        <div class="text-xs text-blue-100 dark:text-blue-200 mb-1">Issued</div>
                        <div class="text-sm">{{ $activeCard->issued_at->format('M d, Y') }}</div>
                    </div>
                    <div>
                        <div class="text-xs text-blue-100 dark:text-blue-200 mb-1">Expires</div>
                        <div class="text-sm">{{ $activeCard->expires_at->format('M d, Y') }}</div>
                    </div>
                </div>

                <div class="flex space-x-3">
                    <a href="{{ route('memberships.download', $activeCard) }}" class="bg-white text-blue-600 px-4 py-2 rounded-lg hover:bg-blue-50 text-sm font-medium transition-colors inline-flex items-center">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        Download PDF
                    </a>
                </div>
            </div>
        </div>

        <!-- Membership Benefits -->
        <div class="bg-white dark:bg-blue-700 rounded-xl p-6 border border-gray-100 dark:border-blue-600 mb-6">
            <h3 class="text-lg font-light text-black dark:text-white mb-4">Your Benefits</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                @if($activeCard->membershipTier->car_discount_percentage > 0)
                <div class="flex items-start">
                    <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                        <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="font-medium text-black dark:text-white">{{ $activeCard->membershipTier->car_discount_percentage }}% Car Discount</div>
                        <div class="text-xs text-gray-500 dark:text-blue-100">Save on every vehicle purchase</div>
                    </div>
                </div>
                @endif

                @if($activeCard->membershipTier->investment_bonus_percentage > 0)
                <div class="flex items-start">
                    <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                        <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="font-medium text-black dark:text-white">{{ $activeCard->membershipTier->investment_bonus_percentage }}% Investment Bonus</div>
                        <div class="text-xs text-gray-500 dark:text-blue-100">Extra returns on investments</div>
                    </div>
                </div>
                @endif

                @if($activeCard->membershipTier->giveaway_entry_multiplier > 1)
                <div class="flex items-start">
                    <div class="w-10 h-10 bg-orange-100 rounded-lg flex items-center justify-center mr-3">
                        <svg class="w-5 h-5 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v13m0-13V6a2 2 0 112 2h-2zm0 0V5.5A2.5 2.5 0 109.5 8H12zm-7 4h14M5 12a2 2 0 110-4h14a2 2 0 110 4M5 12v7a2 2 0 002 2h10a2 2 0 002-2v-7"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="font-medium text-black dark:text-white">{{ $activeCard->membershipTier->giveaway_entry_multiplier }}x Giveaway Entries</div>
                        <div class="text-xs text-gray-500 dark:text-blue-100">Better chances to win prizes</div>
                    </div>
                </div>
                @endif

                @if($activeCard->membershipTier->priority_support)
                <div class="flex items-start">
                    <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                        <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="font-medium text-black dark:text-white">Priority Support</div>
                        <div class="text-xs text-gray-500 dark:text-blue-100">Fast-tracked assistance</div>
                    </div>
                </div>
                @endif
            </div>
        </div>
        @else
        <div class="bg-white dark:bg-blue-700 rounded-xl p-12 text-center border border-gray-100 dark:border-blue-600">
            <svg class="w-16 h-16 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
            </svg>
            <h3 class="text-lg font-light text-black dark:text-white mb-2">No Active Membership</h3>
            <p class="text-gray-500 dark:text-blue-100 text-sm mb-6">Purchase a VIP membership to unlock exclusive benefits</p>
            <a href="{{ route('memberships.index') }}" class="bg-gradient-to-r from-blue-600 to-blue-700 text-white px-6 py-2 rounded-lg hover:from-blue-700 hover:to-blue-800 text-sm font-medium inline-block transition-colors">
                Browse Memberships
            </a>
        </div>
        @endif

        <!-- Past Memberships -->
        @if($cards->where('status', '!=', 'active')->count() > 0)
        <div class="bg-white dark:bg-blue-700 rounded-xl p-6 border border-gray-100 dark:border-blue-600">
            <h3 class="text-lg font-light text-black dark:text-white mb-4">Past Memberships</h3>
            <div class="space-y-3">
                @foreach($cards->where('status', '!=', 'active') as $card)
                <div class="flex items-center justify-between p-3 bg-gray-50 dark:bg-blue-800 rounded-lg border border-gray-200 dark:border-blue-600">
                    <div>
                        <div class="font-medium text-black dark:text-white">{{ $card->membershipTier->name }}</div>
                        <div class="text-xs text-gray-500 dark:text-blue-100">{{ $card->issued_at->format('M d, Y') }} - {{ $card->expires_at->format('M d, Y') }}</div>
                    </div>
                    <span class="inline-flex items-center px-2 py-1 text-xs font-medium rounded {{ $card->status_badge }}">
                        {{ ucfirst($card->status) }}
                    </span>
                </div>
                @endforeach
            </div>
        </div>
        @endif
    </div>
</x-user-layout>
