<x-user-layout>
    <x-slot name="header">
        Giveaway Details
    </x-slot>

    <div class="max-w-4xl mx-auto">
        <div class="bg-white dark:bg-blue-700 rounded-xl overflow-hidden border border-gray-100 dark:border-blue-600 mb-6">
            <!-- Giveaway Image -->
            <div class="relative h-96 bg-gray-200 dark:bg-blue-800">
                <img src="{{ $giveaway->image_url }}" alt="{{ $giveaway->title }}" class="w-full h-full object-cover">
                <div class="absolute top-4 right-4">
                    <span class="inline-flex items-center px-3 py-1 text-sm font-medium rounded {{ $giveaway->status_badge }}">
                        {{ ucfirst($giveaway->status) }}
                    </span>
                </div>
            </div>

            <!-- Giveaway Details -->
            <div class="p-6">
                <h1 class="text-3xl font-light text-black dark:text-white mb-4">{{ $giveaway->title }}</h1>

                @if($giveaway->description)
                <p class="text-gray-700 dark:text-blue-100 mb-6 leading-relaxed">{{ $giveaway->description }}</p>
                @endif

                <!-- Prize Info -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                    <div class="bg-gray-50 dark:bg-blue-800 rounded-lg p-4 border border-gray-200 dark:border-blue-600">
                        <div class="text-sm text-gray-500 dark:text-blue-200 mb-1">Prize Type</div>
                        <div class="text-lg font-medium text-black dark:text-white">{{ ucfirst($giveaway->prize_type) }}</div>
                    </div>

                    @if($giveaway->prize_value)
                    <div class="bg-gray-50 dark:bg-blue-800 rounded-lg p-4 border border-gray-200 dark:border-blue-600">
                        <div class="text-sm text-gray-500 dark:text-blue-200 mb-1">Prize Value</div>
                        <div class="text-lg font-medium text-black dark:text-white">{{ $giveaway->formatted_prize_value }}</div>
                    </div>
                    @endif

                    @if($giveaway->prize_car_id && $giveaway->prizeCar)
                    <div class="bg-gray-50 dark:bg-blue-800 rounded-lg p-4 border border-gray-200 dark:border-blue-600 md:col-span-2">
                        <div class="text-sm text-gray-500 dark:text-blue-200 mb-1">Prize Vehicle</div>
                        <div class="text-lg font-medium text-black dark:text-white">{{ $giveaway->prizeCar->title }}</div>
                    </div>
                    @endif

                    @if($giveaway->prize_details)
                    <div class="bg-gray-50 dark:bg-blue-800 rounded-lg p-4 border border-gray-200 dark:border-blue-600 md:col-span-2">
                        <div class="text-sm text-gray-500 dark:text-blue-200 mb-1">Prize Details</div>
                        <div class="text-sm text-black dark:text-white">{{ $giveaway->prize_details }}</div>
                    </div>
                    @endif
                </div>

                <!-- Timeline & Stats -->
                <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
                    <div class="text-center p-3 bg-gray-50 dark:bg-blue-800 rounded-lg border border-gray-200 dark:border-blue-600">
                        <div class="text-xs text-gray-500 dark:text-blue-200 mb-1">Starts</div>
                        <div class="text-sm font-medium text-black dark:text-white">{{ $giveaway->start_date->format('M d, Y') }}</div>
                    </div>

                    <div class="text-center p-3 bg-gray-50 dark:bg-blue-800 rounded-lg border border-gray-200 dark:border-blue-600">
                        <div class="text-xs text-gray-500 dark:text-blue-200 mb-1">Ends</div>
                        <div class="text-sm font-medium text-black dark:text-white">{{ $giveaway->end_date->format('M d, Y') }}</div>
                    </div>

                    <div class="text-center p-3 bg-gray-50 dark:bg-blue-800 rounded-lg border border-gray-200 dark:border-blue-600">
                        <div class="text-xs text-gray-500 dark:text-blue-200 mb-1">Total Entries</div>
                        <div class="text-sm font-medium text-black dark:text-white">{{ number_format($giveaway->total_entries) }}</div>
                    </div>

                    <div class="text-center p-3 bg-gray-50 dark:bg-blue-800 rounded-lg border border-gray-200 dark:border-blue-600">
                        <div class="text-xs text-gray-500 dark:text-blue-200 mb-1">Participants</div>
                        <div class="text-sm font-medium text-black dark:text-white">{{ number_format($giveaway->unique_participants) }}</div>
                    </div>
                </div>

                <!-- Entry Requirements -->
                <div class="bg-orange-50 dark:bg-orange-900/20 border border-orange-200 dark:border-orange-800 rounded-lg p-4 mb-6">
                    <div class="flex items-start">
                        <svg class="w-5 h-5 text-orange-600 dark:text-orange-400 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                        </svg>
                        <div>
                            <div class="font-medium text-black dark:text-white mb-1">Entry Requirement</div>
                            <div class="text-sm text-gray-700 dark:text-blue-100">{{ $giveaway->entry_requirement_label }}</div>
                        </div>
                    </div>
                </div>

                <!-- Winner Section -->
                @if($giveaway->has_winner)
                <div class="bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 rounded-lg p-6 text-center mb-6">
                    <svg class="w-12 h-12 text-green-600 dark:text-green-400 mx-auto mb-3" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                    </svg>
                    <h3 class="text-lg font-medium text-black dark:text-white mb-2">Winner Selected!</h3>
                    <p class="text-gray-700 dark:text-green-100">Congratulations to <strong>{{ $giveaway->winner->name }}</strong></p>
                    <p class="text-xs text-gray-500 dark:text-green-200 mt-1">Selected on {{ $giveaway->winner_selected_at->format('M d, Y') }}</p>
                </div>
                @endif

                <!-- Entry Status / Action -->
                @if($hasEntered)
                <div class="bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 rounded-lg p-6 text-center">
                    <svg class="w-12 h-12 text-green-600 dark:text-green-400 mx-auto mb-3" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                    </svg>
                    <h3 class="text-lg font-medium text-black dark:text-white mb-2">You're Entered!</h3>
                    @if($userEntry)
                    <p class="text-gray-700 dark:text-green-100">You have <strong>{{ $userEntry->entries_count }} {{ $userEntry->entries_count > 1 ? 'entries' : 'entry' }}</strong> in this giveaway</p>
                    @if($userEntry->entries_count > 1)
                    <p class="text-xs text-gray-500 dark:text-green-200 mt-1">{{ $userEntry->entries_count }}x multiplier from VIP membership</p>
                    @endif
                    @endif
                </div>
                @elseif($canEnter && $giveaway->is_active)
                <form action="{{ route('giveaways.enter', $giveaway) }}" method="POST">
                    @csrf
                    <button type="submit" class="w-full bg-gradient-to-r from-blue-600 to-blue-700 dark:from-blue-600 dark:to-blue-700 text-white py-4 rounded-lg hover:from-blue-700 hover:to-blue-800 transition-colors text-lg font-medium">
                        Enter Giveaway Now
                    </button>
                </form>
                @else
                <div class="bg-gray-50 dark:bg-blue-800 border border-gray-200 dark:border-blue-600 rounded-lg p-6 text-center">
                    <svg class="w-12 h-12 text-gray-400 mx-auto mb-3" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd"></path>
                    </svg>
                    <h3 class="text-lg font-medium text-black dark:text-white mb-2">Entry Not Available</h3>
                    <p class="text-sm text-gray-600 dark:text-blue-100">
                        @if(!$giveaway->is_active)
                            This giveaway is not currently active.
                        @else
                            You don't meet the entry requirements for this giveaway.
                        @endif
                    </p>
                </div>
                @endif
            </div>
        </div>

        <!-- Back Button -->
        <div class="text-center">
            <a href="{{ route('giveaways.index') }}" class="inline-flex items-center text-gray-600 dark:text-blue-100 hover:text-black dark:hover:text-white transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                </svg>
                Back to Giveaways
            </a>
        </div>
    </div>
</x-user-layout>
