<x-user-layout>
    <x-slot name="header">
        My Giveaway Entries
    </x-slot>

    <div class="max-w-5xl mx-auto">
        <div class="bg-gradient-to-br from-blue-600 via-blue-700 to-blue-800 dark:from-blue-700 dark:via-blue-800 dark:to-blue-900 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 right-0 w-48 h-48 bg-white rounded-full -translate-y-24 translate-x-24"></div>
            </div>
            
            <div class="relative z-10">
                <h1 class="text-xl font-light mb-2">My Giveaway Entries</h1>
                <p class="text-blue-100 dark:text-blue-200 text-sm">Track all your giveaway participations and see your chances to win</p>
            </div>
        </div>

        @if($entries->count() > 0)
        <div class="space-y-4">
            @foreach($entries as $entry)
            <div class="bg-white dark:bg-blue-700 rounded-xl overflow-hidden border border-gray-100 dark:border-blue-600 hover:shadow-lg transition-all duration-300">
                <div class="md:flex">
                    <!-- Giveaway Image -->
                    <div class="md:w-48 h-48 md:h-auto bg-gray-200 dark:bg-blue-800 flex-shrink-0">
                        <img src="{{ $entry->giveaway->image_url }}" alt="{{ $entry->giveaway->title }}" class="w-full h-full object-cover">
                    </div>

                    <!-- Entry Details -->
                    <div class="flex-1 p-6">
                        <div class="flex justify-between items-start mb-4">
                            <div>
                                <h3 class="text-lg font-light text-black dark:text-white mb-1">{{ $entry->giveaway->title }}</h3>
                                <p class="text-sm text-gray-600 dark:text-blue-100">{{ ucfirst($entry->giveaway->prize_type) }} Prize</p>
                            </div>
                            <span class="inline-flex items-center px-2 py-1 text-xs font-medium rounded {{ $entry->giveaway->status_badge }}">
                                {{ ucfirst($entry->giveaway->status) }}
                            </span>
                        </div>

                        <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-4">
                            <div>
                                <div class="text-xs text-gray-500 dark:text-blue-200 mb-1">My Entries</div>
                                <div class="text-lg font-medium text-black dark:text-white">{{ $entry->entries_count }}</div>
                                @if($entry->entries_count > 1)
                                <span class="inline-flex items-center px-2 py-0.5 text-xs font-medium bg-orange-100 text-orange-800 rounded">
                                    {{ $entry->multiplier_badge }}
                                </span>
                                @endif
                            </div>

                            <div>
                                <div class="text-xs text-gray-500 dark:text-blue-200 mb-1">Total Entries</div>
                                <div class="text-lg font-medium text-black dark:text-white">{{ number_format($entry->giveaway->total_entries) }}</div>
                            </div>

                            <div>
                                <div class="text-xs text-gray-500 dark:text-blue-200 mb-1">Entered On</div>
                                <div class="text-sm text-black dark:text-white">{{ $entry->entered_at->format('M d, Y') }}</div>
                            </div>

                            <div>
                                <div class="text-xs text-gray-500 dark:text-blue-200 mb-1">Status</div>
                                @if($entry->giveaway->is_active)
                                    <div class="text-sm text-green-600 dark:text-green-400 font-medium">
                                        {{ $entry->giveaway->days_remaining }} days left
                                    </div>
                                @elseif($entry->giveaway->has_winner)
                                    @if($entry->giveaway->winner_user_id == auth()->id())
                                        <div class="text-sm text-green-600 dark:text-green-400 font-medium">🎉 You Won!</div>
                                    @else
                                        <div class="text-sm text-gray-500 dark:text-blue-100">Ended</div>
                                    @endif
                                @else
                                    <div class="text-sm text-gray-500 dark:text-blue-100">Ended</div>
                                @endif
                            </div>
                        </div>

                        <div class="flex items-center justify-between">
                            <div class="text-xs text-gray-500 dark:text-blue-100">
                                Source: {{ $entry->entry_source_label }}
                            </div>
                            <a href="{{ route('giveaways.show', $entry->giveaway) }}" class="text-sm text-blue-600 dark:text-blue-300 hover:text-blue-700 dark:hover:text-blue-200 font-medium">
                                View Details →
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>

        <!-- Pagination -->
        <div class="mt-6">
            {{ $entries->links() }}
        </div>
        @else
        <div class="bg-white dark:bg-blue-700 rounded-xl p-12 text-center border border-gray-100 dark:border-blue-600">
            <svg class="w-16 h-16 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v13m0-13V6a2 2 0 112 2h-2zm0 0V5.5A2.5 2.5 0 109.5 8H12zm-7 4h14M5 12a2 2 0 110-4h14a2 2 0 110 4M5 12v7a2 2 0 002 2h10a2 2 0 002-2v-7"></path>
            </svg>
            <h3 class="text-lg font-light text-black dark:text-white mb-2">No Entries Yet</h3>
            <p class="text-gray-500 dark:text-blue-100 text-sm mb-6">Start participating in giveaways to see your entries here</p>
            <a href="{{ route('giveaways.index') }}" class="bg-gradient-to-r from-blue-600 to-blue-700 text-white px-6 py-2 rounded-lg hover:from-blue-700 hover:to-blue-800 text-sm font-medium inline-block transition-colors">
                Browse Giveaways
            </a>
        </div>
        @endif
    </div>
</x-user-layout>
