<x-user-layout>
    <x-slot name="header">
        Giveaways
    </x-slot>

    <div class="max-w-7xl mx-auto">
        <!-- Header Section -->
        <div class="bg-gradient-to-br from-blue-600 via-blue-700 to-blue-800 dark:from-blue-700 dark:via-blue-800 dark:to-blue-900 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 right-0 w-48 h-48 bg-white rounded-full -translate-y-24 translate-x-24"></div>
            </div>
            
            <div class="relative z-10 flex justify-between items-center">
                <div>
                    <h1 class="text-xl font-light mb-2">Enter to Win Amazing Prizes!</h1>
                    <p class="text-blue-100 dark:text-blue-200 text-sm">Participate in our exclusive giveaways and win cars, cash, and more</p>
                </div>
                <a href="{{ route('giveaways.my-entries') }}" class="bg-white text-blue-600 px-4 py-2 rounded-lg hover:bg-blue-50 text-sm font-medium transition-colors">
                    My Entries
                </a>
            </div>
        </div>

        <!-- Active Giveaways -->
        @if($activeGiveaways->count() > 0)
        <div class="mb-8">
            <h2 class="text-lg font-light text-black dark:text-white mb-4">Active Giveaways</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                @foreach($activeGiveaways as $giveaway)
                <div class="bg-white dark:bg-blue-700 rounded-xl overflow-hidden border border-gray-100 dark:border-blue-600 hover:shadow-lg transition-all duration-300 group">
                    <div class="relative h-48 bg-gray-200 dark:bg-blue-800 overflow-hidden">
                        <img src="{{ $giveaway->image_url }}" alt="{{ $giveaway->title }}" class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-300">
                        <div class="absolute top-3 right-3">
                            <span class="inline-flex items-center px-2 py-1 text-xs font-medium rounded bg-green-100 text-green-800">
                                Active
                            </span>
                        </div>
                    </div>

                    <div class="p-4">
                        <h3 class="text-lg font-light text-black dark:text-white mb-2">{{ $giveaway->title }}</h3>
                        
                        @if($giveaway->description)
                        <p class="text-sm text-gray-600 dark:text-blue-100 mb-3 line-clamp-2">{{ $giveaway->description }}</p>
                        @endif

                        <div class="space-y-2 mb-4">
                            <div class="flex items-center text-sm">
                                <svg class="w-4 h-4 text-gray-400 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v13m0-13V6a2 2 0 112 2h-2zm0 0V5.5A2.5 2.5 0 109.5 8H12zm-7 4h14M5 12a2 2 0 110-4h14a2 2 0 110 4M5 12v7a2 2 0 002 2h10a2 2 0 002-2v-7"></path>
                                </svg>
                                <span class="text-gray-700 dark:text-blue-100">{{ ucfirst($giveaway->prize_type) }} Prize</span>
                            </div>

                            @if($giveaway->prize_value)
                            <div class="flex items-center text-sm">
                                <svg class="w-4 h-4 text-gray-400 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <span class="text-gray-700 dark:text-blue-100 font-medium">{{ $giveaway->formatted_prize_value }}</span>
                            </div>
                            @endif

                            <div class="flex items-center text-sm">
                                <svg class="w-4 h-4 text-gray-400 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <span class="text-gray-700 dark:text-blue-100">Ends in {{ $giveaway->days_remaining }} days</span>
                            </div>

                            <div class="flex items-center text-sm">
                                <svg class="w-4 h-4 text-gray-400 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                </svg>
                                <span class="text-gray-700 dark:text-blue-100">{{ $giveaway->unique_participants }} participants</span>
                            </div>
                        </div>

                        @if(in_array($giveaway->id, $userEntries))
                        <div class="flex items-center justify-center bg-green-50 dark:bg-green-900/20 text-green-700 dark:text-green-300 py-2 rounded-lg text-sm font-medium">
                            <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                            </svg>
                            Entered
                        </div>
                        @else
                        <a href="{{ route('giveaways.show', $giveaway) }}" class="block w-full bg-gradient-to-r from-blue-600 to-blue-700 dark:from-blue-600 dark:to-blue-700 text-white py-2 rounded-lg hover:from-blue-700 hover:to-blue-800 transition-colors text-sm font-medium text-center">
                            View Details & Enter
                        </a>
                        @endif
                    </div>
                </div>
                @endforeach
            </div>
        </div>
        @else
        <div class="bg-white dark:bg-blue-700 rounded-xl p-12 text-center border border-gray-100 dark:border-blue-600 mb-8">
            <svg class="w-16 h-16 text-gray-400 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v13m0-13V6a2 2 0 112 2h-2zm0 0V5.5A2.5 2.5 0 109.5 8H12zm-7 4h14M5 12a2 2 0 110-4h14a2 2 0 110 4M5 12v7a2 2 0 002 2h10a2 2 0 002-2v-7"></path>
            </svg>
            <h3 class="text-lg font-light text-black dark:text-white mb-2">No Active Giveaways</h3>
            <p class="text-gray-500 dark:text-blue-100 text-sm">Check back soon for new opportunities to win amazing prizes!</p>
        </div>
        @endif

        <!-- Upcoming Giveaways -->
        @if($upcomingGiveaways->count() > 0)
        <div>
            <h2 class="text-lg font-light text-black dark:text-white mb-4">Coming Soon</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                @foreach($upcomingGiveaways as $giveaway)
                <div class="bg-white dark:bg-blue-700 rounded-xl overflow-hidden border border-gray-100 dark:border-blue-600 opacity-75">
                    <div class="relative h-48 bg-gray-200 dark:bg-blue-800">
                        <img src="{{ $giveaway->image_url }}" alt="{{ $giveaway->title }}" class="w-full h-full object-cover">
                        <div class="absolute inset-0 bg-black bg-opacity-40 flex items-center justify-center">
                            <div class="text-center text-white">
                                <div class="text-sm mb-1">Starts</div>
                                <div class="text-lg font-medium">{{ $giveaway->start_date->format('M d, Y') }}</div>
                            </div>
                        </div>
                    </div>

                    <div class="p-4">
                        <h3 class="text-lg font-light text-black dark:text-white mb-2">{{ $giveaway->title }}</h3>
                        @if($giveaway->prize_value)
                        <div class="text-sm text-gray-600 dark:text-blue-100">Prize: {{ $giveaway->formatted_prize_value }}</div>
                        @endif
                    </div>
                </div>
                @endforeach
            </div>
        </div>
        @endif
    </div>
</x-user-layout>
