@extends('layouts.error')

@section('title', '419 - Page Expired')

@section('content')
<div class="min-h-screen bg-white">
  <header class="relative overflow-hidden bg-gradient-to-br from-black via-gray-900 to-black text-white">
    <div class="relative z-10">
      <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8 py-14 lg:py-20 text-center">
        <p class="text-sm uppercase tracking-widest text-white/70">Error</p>
        <h1 class="mt-2 text-5xl font-semibold">419</h1>
        <p class="mt-3 text-lg text-white/80">Page Expired</p>
      </div>
    </div>
  </header>

  <section class="py-16 bg-white">
    <div class="mx-auto max-w-3xl px-4 sm:px-6 lg:px-8">
      <div class="rounded-2xl border border-gray-200 dark:border-blue-600 bg-white p-8 shadow-sm text-center">
        <p class="text-gray-700">This usually happens when your session has expired or there was a security token mismatch.</p>
        <div class="mt-6 flex flex-col items-center justify-center gap-3 sm:flex-row">
          <a href="{{ url()->previous() }}" class="rounded-md border border-gray-300 px-6 py-3 text-sm font-medium text-black transition hover:bg-gray-50">Go Back</a>
          <a href="{{ route('home') }}" class="rounded-md bg-black px-6 py-3 text-sm font-medium text-white transition hover:bg-gray-800">Reload & Go Home</a>
        </div>
      </div>
    </div>
  </section>
</div>
@endsection


