<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cron Job Setup - Wget Commands</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            overflow: hidden;
        }
        .header {
            background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
            color: white;
            padding: 40px;
            text-align: center;
        }
        .header h1 { font-size: 2.5em; margin-bottom: 10px; }
        .header p { font-size: 1.1em; opacity: 0.9; }
        .content { padding: 40px; }
        .section {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 25px;
            margin-bottom: 30px;
        }
        .section h2 {
            color: #1e3c72;
            margin-bottom: 20px;
            font-size: 1.8em;
            border-bottom: 3px solid #667eea;
            padding-bottom: 10px;
        }
        .job-card {
            background: white;
            border-left: 4px solid #667eea;
            padding: 20px;
            margin-bottom: 15px;
            border-radius: 5px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        .job-card h3 {
            color: #2a5298;
            margin-bottom: 10px;
            font-size: 1.3em;
        }
        .job-card p {
            color: #666;
            margin-bottom: 15px;
        }
        .command {
            background: #2d3748;
            color: #68d391;
            padding: 15px;
            border-radius: 5px;
            font-family: 'Courier New', monospace;
            font-size: 14px;
            overflow-x: auto;
            white-space: pre;
            margin-bottom: 10px;
        }
        .copy-btn {
            background: #667eea;
            color: white;
            border: none;
            padding: 8px 20px;
            border-radius: 5px;
            cursor: pointer;
            font-size: 14px;
            transition: all 0.3s;
        }
        .copy-btn:hover {
            background: #5568d3;
            transform: translateY(-2px);
        }
        .alert {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 5px;
        }
        .alert-success {
            background: #d4edda;
            border-left-color: #28a745;
        }
        .test-btn {
            background: #28a745;
            color: white;
            border: none;
            padding: 10px 25px;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            margin-right: 10px;
            transition: all 0.3s;
        }
        .test-btn:hover {
            background: #218838;
            transform: translateY(-2px);
        }
        .crontab-example {
            background: #e7f3ff;
            border-left: 4px solid #0066cc;
            padding: 20px;
            border-radius: 5px;
            margin-top: 15px;
        }
        .token-display {
            background: #ffe5e5;
            border: 2px dashed #ff6b6b;
            padding: 20px;
            border-radius: 10px;
            text-align: center;
            margin-bottom: 20px;
        }
        .token-value {
            font-size: 1.5em;
            font-weight: bold;
            color: #c92a2a;
            font-family: monospace;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🕐 Cron Job Setup</h1>
            <p>Automated Task Scheduler with Wget Commands</p>
        </div>

        <div class="content">
            <!-- Token Display -->
            <div class="token-display">
                <h3>🔐 Your Security Token</h3>
                <div class="token-value">{{ env('CRON_TOKEN', 'NOT_SET') }}</div>
                <p style="margin-top: 10px; color: #666;">Keep this token secure! Don't share it publicly.</p>
            </div>

            <div class="alert">
                <strong>⚠️ Important:</strong> Replace <code>YOUR_DOMAIN</code> with <strong>{{ config('app.url') }}</strong> and <code>YOUR_TOKEN</code> with your security token above.
            </div>

            <!-- Run All Jobs -->
            <div class="section">
                <h2>🚀 Run All Jobs (Recommended)</h2>
                <div class="job-card">
                    <h3>Execute All Tasks</h3>
                    <p>Runs all jobs at once - perfect for general maintenance</p>
                    <div class="command">wget -q -O- "{{ config('app.url') }}/cron/run-all?token={{ env('CRON_TOKEN') }}"</div>
                    <button class="copy-btn" onclick="copyCommand(this)">📋 Copy Command</button>
                    <button class="test-btn" onclick="testEndpoint('/cron/run-all')">🧪 Test Now</button>
                </div>
            </div>

            <!-- Individual Jobs -->
            <div class="section">
                <h2>🎯 Individual Job Commands</h2>
                
                <div class="job-card">
                    <h3>📈 Update Stock Quotes</h3>
                    <p>Updates real-time stock prices and market data (Run every 5 minutes during market hours)</p>
                    <div class="command">wget -q -O- "{{ config('app.url') }}/cron/update-stock-quotes?token={{ env('CRON_TOKEN') }}"</div>
                    <button class="copy-btn" onclick="copyCommand(this)">📋 Copy Command</button>
                    <button class="test-btn" onclick="testEndpoint('/cron/update-stock-quotes')">🧪 Test Now</button>
                </div>

                <div class="job-card">
                    <h3>📊 Fetch Stock History</h3>
                    <p>Retrieves historical stock data for charts and analysis (Run daily)</p>
                    <div class="command">wget -q -O- "{{ config('app.url') }}/cron/fetch-stock-history?token={{ env('CRON_TOKEN') }}"</div>
                    <button class="copy-btn" onclick="copyCommand(this)">📋 Copy Command</button>
                    <button class="test-btn" onclick="testEndpoint('/cron/fetch-stock-history')">🧪 Test Now</button>
                </div>

                <div class="job-card">
                    <h3>📰 Process Stock News</h3>
                    <p>Fetches and processes latest stock market news (Run every hour)</p>
                    <div class="command">wget -q -O- "{{ config('app.url') }}/cron/process-stock-news?token={{ env('CRON_TOKEN') }}"</div>
                    <button class="copy-btn" onclick="copyCommand(this)">📋 Copy Command</button>
                    <button class="test-btn" onclick="testEndpoint('/cron/process-stock-news')">🧪 Test Now</button>
                </div>

                <div class="job-card">
                    <h3>💰 Process NAV Updates</h3>
                    <p>Updates Net Asset Values for investment portfolios (Run daily)</p>
                    <div class="command">wget -q -O- "{{ config('app.url') }}/cron/process-nav-updates?token={{ env('CRON_TOKEN') }}"</div>
                    <button class="copy-btn" onclick="copyCommand(this)">📋 Copy Command</button>
                    <button class="test-btn" onclick="testEndpoint('/cron/process-nav-updates')">🧪 Test Now</button>
                </div>

                <div class="job-card">
                    <h3>🗑️ Cleanup Old Data</h3>
                    <p>Removes outdated records and optimizes database (Run daily at night)</p>
                    <div class="command">wget -q -O- "{{ config('app.url') }}/cron/cleanup-old-data?token={{ env('CRON_TOKEN') }}"</div>
                    <button class="copy-btn" onclick="copyCommand(this)">📋 Copy Command</button>
                    <button class="test-btn" onclick="testEndpoint('/cron/cleanup-old-data')">🧪 Test Now</button>
                </div>
            </div>

            <!-- Crontab Examples -->
            <div class="section">
                <h2>⏰ Linux Crontab Setup</h2>
                <p style="margin-bottom: 15px;">Add these lines to your crontab (run: <code>crontab -e</code>)</p>
                
                <div class="crontab-example">
                    <h4 style="margin-bottom: 15px;">Option 1: Run All Jobs Every 5 Minutes</h4>
                    <div class="command">*/5 * * * * wget -q -O- "{{ config('app.url') }}/cron/run-all?token={{ env('CRON_TOKEN') }}" >/dev/null 2>&1</div>
                    <button class="copy-btn" onclick="copyCommand(this)">📋 Copy Crontab</button>
                </div>

                <div class="crontab-example" style="margin-top: 20px;">
                    <h4 style="margin-bottom: 15px;">Option 2: Individual Schedules</h4>
                    <div class="command"># Update stock quotes every 5 minutes (9 AM - 4 PM, Mon-Fri)
*/5 9-16 * * 1-5 wget -q -O- "{{ config('app.url') }}/cron/update-stock-quotes?token={{ env('CRON_TOKEN') }}" >/dev/null 2>&1

# Fetch history daily at 6 AM
0 6 * * * wget -q -O- "{{ config('app.url') }}/cron/fetch-stock-history?token={{ env('CRON_TOKEN') }}" >/dev/null 2>&1

# Process news every hour
0 * * * * wget -q -O- "{{ config('app.url') }}/cron/process-stock-news?token={{ env('CRON_TOKEN') }}" >/dev/null 2>&1

# Process NAV updates daily at 7 AM
0 7 * * * wget -q -O- "{{ config('app.url') }}/cron/process-nav-updates?token={{ env('CRON_TOKEN') }}" >/dev/null 2>&1

# Cleanup old data daily at 2 AM
0 2 * * * wget -q -O- "{{ config('app.url') }}/cron/cleanup-old-data?token={{ env('CRON_TOKEN') }}" >/dev/null 2>&1</div>
                    <button class="copy-btn" onclick="copyCommand(this)">📋 Copy All Crontabs</button>
                </div>
            </div>

            <!-- Status Check -->
            <div class="section">
                <h2>✅ Status & Testing</h2>
                <div class="job-card">
                    <h3>Check Cron System Status</h3>
                    <p>Verify that the cron system is working and see available jobs</p>
                    <div class="command">wget -q -O- "{{ config('app.url') }}/cron/status?token={{ env('CRON_TOKEN') }}"</div>
                    <button class="copy-btn" onclick="copyCommand(this)">📋 Copy Command</button>
                    <button class="test-btn" onclick="testEndpoint('/cron/status')">🧪 Check Status</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        function copyCommand(button) {
            const command = button.previousElementSibling.textContent;
            navigator.clipboard.writeText(command).then(() => {
                const originalText = button.textContent;
                button.textContent = '✅ Copied!';
                button.style.background = '#28a745';
                setTimeout(() => {
                    button.textContent = originalText;
                    button.style.background = '#667eea';
                }, 2000);
            });
        }

        function testEndpoint(endpoint) {
            const token = '{{ env("CRON_TOKEN") }}';
            const url = `${endpoint}?token=${token}`;
            
            window.open(url, '_blank');
        }
    </script>
</body>
</html>
