<x-guest-layout>
    <x-slot name="title">Verify Email</x-slot>

    <div class="bg-white rounded-lg shadow-sm border overflow-hidden" style="background-color: white; border-color: #e5e7eb;">
        <!-- Header -->
        <div class="px-8 py-8 text-center">
            <h1 class="text-3xl font-light mb-2" style="color: #C8102E;">Verify Email</h1>
            <p style="color: #7D0A1D;">Check your inbox for verification</p>
        </div>

        <!-- Verification Content -->
        <div class="px-8 pb-8">
            <div class="mb-6 text-sm text-center" style="color: #7D0A1D;">
                Thanks for signing up! Before getting started, could you verify your email address by clicking on the link we just emailed to you? If you didn't receive the email, we will gladly send you another.
            </div>

            @if (session('status') == 'verification-link-sent')
                <div class="bg-green-50 border-l-4 border-green-500 p-4 mb-6">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm text-green-700">A new verification link has been sent to the email address you provided during registration.</p>
                        </div>
                    </div>
                </div>
            @endif

            <div class="flex flex-col space-y-4">
                <!-- Resend Verification Email -->
                <form method="POST" action="{{ route('verification.send') }}">
                    @csrf
                    <button type="submit" 
                            style="background-color: #C8102E;" 
                            onmouseover="this.style.backgroundColor='#A00D25'" 
                            onmouseout="this.style.backgroundColor='#C8102E'"
                            class="w-full text-white py-3 px-6 rounded-md text-base font-medium transition-all duration-200">
                        Resend Verification Email
                    </button>
                </form>

                <!-- Log Out -->
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <button type="submit" class="w-full border py-3 px-6 rounded-md text-base font-medium transition-all duration-200" style="border-color: #d1d5db; color: #7D0A1D; background-color: white;" onmouseover="this.style.backgroundColor='#f9fafb'" onmouseout="this.style.backgroundColor='white'">
                        Log Out
                    </button>
                </form>
            </div>
        </div>

        <!-- Help Section -->
        <div class="px-8 py-6 border-t text-center" style="background-color: #f9fafb; border-color: #e5e7eb;">
            <p class="text-sm" style="color: #7D0A1D;">
                Need help? 
                <a href="#" class="text-[#C8102E] hover:text-[#A00D25] font-medium transition-colors duration-200">
                    Contact Support
                </a>
            </p>
        </div>
    </div>
</x-guest-layout>
