<x-guest-layout>
    <x-slot name="title">Reset Password</x-slot>

    <div class="bg-white rounded-xl shadow-sm border overflow-hidden" style="background-color: white; border-color: #e5e7eb;">
        <!-- Enhanced Header -->
        <div class="px-6 py-6 text-center">
            <h1 class="text-xl font-light mb-1" style="color: #C8102E;">Reset Password</h1>
            <p class="text-xs" style="color: #7D0A1D;">Enter your new password</p>
        </div>

        <!-- Reset Form -->
        <div class="px-6 pb-6">
            <form method="POST" action="{{ route('password.store') }}" class="space-y-4">
                @csrf

                <!-- Password Reset Token -->
                <input type="hidden" name="token" value="{{ $request->route('token') }}">

                <!-- Email Address -->
                <div>
                    <label for="email" class="block text-xs font-medium text-[#C8102E] dark:text-white mb-1">Email</label>
                    <input type="email" 
                           id="email" 
                           name="email" 
                           value="{{ old('email', $request->email) }}" 
                           required 
                           autofocus 
                           autocomplete="username" 
                           style="border-color: #d1d5db;"
                           class="w-full px-3 py-2.5 border rounded-lg focus:outline-none focus:ring-2 focus:border-transparent transition-colors duration-200 @error('email') border-red-500 @enderror"
                           onfocus="this.style.borderColor='#C8102E'; this.style.outline='2px solid #C8102E';"
                           onblur="this.style.borderColor='#d1d5db'; this.style.outline='none';">
                    @error('email')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Password -->
                <div>
                    <label for="password" class="block text-xs font-medium text-[#C8102E] dark:text-white mb-1">New Password</label>
                    <input type="password" 
                           id="password" 
                           name="password" 
                           required 
                           autocomplete="new-password"
                           style="border-color: #d1d5db;"
                           class="w-full px-3 py-2.5 border rounded-lg focus:outline-none focus:ring-2 focus:border-transparent transition-colors duration-200 @error('password') border-red-500 @enderror"
                           onfocus="this.style.borderColor='#C8102E'; this.style.outline='2px solid #C8102E';"
                           onblur="this.style.borderColor='#d1d5db'; this.style.outline='none';">
                    @error('password')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Confirm Password -->
                <div>
                    <label for="password_confirmation" class="block text-xs font-medium text-[#C8102E] dark:text-white mb-1">Confirm New Password</label>
                    <input type="password" 
                           id="password_confirmation" 
                           name="password_confirmation" 
                           required 
                           autocomplete="new-password"
                           style="border-color: #d1d5db;"
                           class="w-full px-3 py-2.5 border rounded-lg focus:outline-none focus:ring-2 focus:border-transparent transition-colors duration-200 @error('password_confirmation') border-red-500 @enderror"
                           onfocus="this.style.borderColor='#C8102E'; this.style.outline='2px solid #C8102E';"
                           onblur="this.style.borderColor='#d1d5db'; this.style.outline='none';">
                    @error('password_confirmation')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Submit Button -->
                <div class="pt-2">
                    <button type="submit" 
                            style="background-color: #C8102E;" 
                            onmouseover="this.style.backgroundColor='#A00D25'" 
                            onmouseout="this.style.backgroundColor='#C8102E'"
                            class="w-full text-white py-2.5 px-4 rounded-lg text-sm font-medium transition-all duration-200">
                        Reset Password
                    </button>
                </div>
            </form>
        </div>

        <!-- Back to Login Link -->
        <div class="px-6 py-4 border-t text-center" style="background-color: #f9fafb; border-color: #e5e7eb;">
            <p class="text-xs" style="color: #7D0A1D;">
                Remember your password?
                <a href="{{ route('login') }}" class="text-[#C8102E] hover:text-[#A00D25] font-medium transition-colors duration-200">
                    Sign in
                </a>
            </p>
        </div>
    </div>
</x-guest-layout>
