<x-guest-layout>
    <x-slot name="title">Create Account</x-slot>

    <div class="bg-white rounded-xl shadow-sm border overflow-hidden transition-colors duration-200" style="background-color: white; border-color: #e5e7eb;">
        <!-- Enhanced Header -->
        <div class="px-6 py-6 text-center">
            <h1 class="text-xl font-light mb-1" style="color: #C8102E;">Create Account</h1>
            <p class="text-xs" style="color: #7D0A1D;">Join Tesla Drives today</p>
        </div>

        <!-- Registration Form -->
        <div class="px-6 pb-6">
            <form method="POST" action="{{ route('register') }}" class="space-y-4">
                @csrf

                <!-- Name -->
                <div>
                    <label for="name" class="block text-xs font-medium text-[#C8102E] dark:text-white mb-1">Full Name</label>
                    <input type="text" 
                           id="name" 
                           name="name" 
                           value="{{ old('name') }}" 
                           required 
                           autofocus 
                           autocomplete="name" 
                           style="border-color: #d1d5db;"
                           class="w-full px-3 py-2.5 border rounded-lg focus:outline-none focus:ring-2 focus:border-transparent transition-colors duration-200 @error('name') border-red-500 @enderror"
                           onfocus="this.style.borderColor='#C8102E'; this.style.outline='2px solid #C8102E';"
                           onblur="this.style.borderColor='#d1d5db'; this.style.outline='none';">
                    @error('name')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Email Address -->
                <div>
                    <label for="email" class="block text-xs font-medium text-[#C8102E] dark:text-white mb-1">Email</label>
                    <input type="email" 
                           id="email" 
                           name="email" 
                           value="{{ old('email') }}" 
                           required 
                           autocomplete="username"
                           style="border-color: #d1d5db;"
                           class="w-full px-3 py-2.5 border rounded-lg focus:outline-none focus:ring-2 focus:border-transparent transition-colors duration-200 @error('email') border-red-500 @enderror"
                           onfocus="this.style.borderColor='#C8102E'; this.style.outline='2px solid #C8102E';"
                           onblur="this.style.borderColor='#d1d5db'; this.style.outline='none';">
                    @error('email')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Password -->
                <div>
                    <label for="password" class="block text-xs font-medium text-[#C8102E] dark:text-white mb-1">Password</label>
                    <input type="password" 
                           id="password" 
                           name="password" 
                           required 
                           autocomplete="new-password"
                           style="border-color: #d1d5db;"
                           class="w-full px-3 py-2.5 border rounded-lg focus:outline-none focus:ring-2 focus:border-transparent transition-colors duration-200 @error('password') border-red-500 @enderror"
                           onfocus="this.style.borderColor='#C8102E'; this.style.outline='2px solid #C8102E';"
                           onblur="this.style.borderColor='#d1d5db'; this.style.outline='none';">
                    @error('password')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Confirm Password -->
                <div>
                    <label for="password_confirmation" class="block text-xs font-medium text-[#C8102E] dark:text-white mb-1">Confirm Password</label>
                    <input type="password" 
                           id="password_confirmation" 
                           name="password_confirmation" 
                           required 
                           autocomplete="new-password"
                           style="border-color: #d1d5db;"
                           class="w-full px-3 py-2.5 border rounded-lg focus:outline-none focus:ring-2 focus:border-transparent transition-colors duration-200 @error('password_confirmation') border-red-500 @enderror"
                           onfocus="this.style.borderColor='#C8102E'; this.style.outline='2px solid #C8102E';"
                           onblur="this.style.borderColor='#d1d5db'; this.style.outline='none';">
                    @error('password_confirmation')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Country -->
                <div>
                    <label for="country" class="block text-xs font-medium text-[#C8102E] dark:text-white mb-1">Country</label>
                    <select id="country" 
                            name="country"
                            style="border-color: #d1d5db;"
                            class="w-full px-3 py-2.5 border rounded-lg focus:outline-none focus:ring-2 focus:border-transparent transition-colors duration-200 @error('country') border-red-500 @enderror"
                            onfocus="this.style.borderColor='#C8102E'; this.style.outline='2px solid #C8102E';"
                            onblur="this.style.borderColor='#d1d5db'; this.style.outline='none';">
                        <option value="">Select Country</option>
                    </select>
                    @error('country')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Currency -->
                <div>
                    <label for="currency" class="block text-xs font-medium text-[#C8102E] dark:text-white mb-1">Preferred Currency</label>
                    <select id="currency" 
                            name="currency"
                            style="border-color: #d1d5db;"
                            class="w-full px-3 py-2.5 border rounded-lg focus:outline-none focus:ring-2 focus:border-transparent transition-colors duration-200 @error('currency') border-red-500 @enderror"
                            onfocus="this.style.borderColor='#C8102E'; this.style.outline='2px solid #C8102E';"
                            onblur="this.style.borderColor='#d1d5db'; this.style.outline='none';">
                        <option value="USD" {{ old('currency') == 'USD' ? 'selected' : '' }}>USD - US Dollar ($)</option>
                        <option value="EUR" {{ old('currency') == 'EUR' ? 'selected' : '' }}>EUR - Euro (€)</option>
                        <option value="GBP" {{ old('currency') == 'GBP' ? 'selected' : '' }}>GBP - British Pound (£)</option>
                        <option value="JPY" {{ old('currency') == 'JPY' ? 'selected' : '' }}>JPY - Japanese Yen (¥)</option>
                        <option value="AUD" {{ old('currency') == 'AUD' ? 'selected' : '' }}>AUD - Australian Dollar (A$)</option>
                        <option value="CAD" {{ old('currency') == 'CAD' ? 'selected' : '' }}>CAD - Canadian Dollar (C$)</option>
                        <option value="CHF" {{ old('currency') == 'CHF' ? 'selected' : '' }}>CHF - Swiss Franc (CHF)</option>
                        <option value="CNY" {{ old('currency') == 'CNY' ? 'selected' : '' }}>CNY - Chinese Yuan (¥)</option>
                        <option value="INR" {{ old('currency') == 'INR' ? 'selected' : '' }}>INR - Indian Rupee (₹)</option>
                        <option value="KRW" {{ old('currency') == 'KRW' ? 'selected' : '' }}>KRW - South Korean Won (₩)</option>
                        <option value="MXN" {{ old('currency') == 'MXN' ? 'selected' : '' }}>MXN - Mexican Peso ($)</option>
                        <option value="BRL" {{ old('currency') == 'BRL' ? 'selected' : '' }}>BRL - Brazilian Real (R$)</option>
                        <option value="ZAR" {{ old('currency') == 'ZAR' ? 'selected' : '' }}>ZAR - South African Rand (R)</option>
                        <option value="RUB" {{ old('currency') == 'RUB' ? 'selected' : '' }}>RUB - Russian Ruble (₽)</option>
                        <option value="SEK" {{ old('currency') == 'SEK' ? 'selected' : '' }}>SEK - Swedish Krona (kr)</option>
                        <option value="NOK" {{ old('currency') == 'NOK' ? 'selected' : '' }}>NOK - Norwegian Krone (kr)</option>
                        <option value="DKK" {{ old('currency') == 'DKK' ? 'selected' : '' }}>DKK - Danish Krone (kr)</option>
                        <option value="SGD" {{ old('currency') == 'SGD' ? 'selected' : '' }}>SGD - Singapore Dollar (S$)</option>
                        <option value="HKD" {{ old('currency') == 'HKD' ? 'selected' : '' }}>HKD - Hong Kong Dollar (HK$)</option>
                        <option value="NZD" {{ old('currency') == 'NZD' ? 'selected' : '' }}>NZD - New Zealand Dollar (NZ$)</option>
                        <option value="TRY" {{ old('currency') == 'TRY' ? 'selected' : '' }}>TRY - Turkish Lira (₺)</option>
                        <option value="PLN" {{ old('currency') == 'PLN' ? 'selected' : '' }}>PLN - Polish Zloty (zł)</option>
                        <option value="THB" {{ old('currency') == 'THB' ? 'selected' : '' }}>THB - Thai Baht (฿)</option>
                        <option value="IDR" {{ old('currency') == 'IDR' ? 'selected' : '' }}>IDR - Indonesian Rupiah (Rp)</option>
                        <option value="MYR" {{ old('currency') == 'MYR' ? 'selected' : '' }}>MYR - Malaysian Ringgit (RM)</option>
                        <option value="PHP" {{ old('currency') == 'PHP' ? 'selected' : '' }}>PHP - Philippine Peso (₱)</option>
                        <option value="CZK" {{ old('currency') == 'CZK' ? 'selected' : '' }}>CZK - Czech Koruna (Kč)</option>
                        <option value="ILS" {{ old('currency') == 'ILS' ? 'selected' : '' }}>ILS - Israeli Shekel (₪)</option>
                        <option value="CLP" {{ old('currency') == 'CLP' ? 'selected' : '' }}>CLP - Chilean Peso ($)</option>
                        <option value="AED" {{ old('currency') == 'AED' ? 'selected' : '' }}>AED - UAE Dirham (د.إ)</option>
                    </select>
                    @error('currency')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Submit Button -->
                <div class="pt-2">
                    <button type="submit" 
                            style="background-color: #C8102E;" 
                            onmouseover="this.style.backgroundColor='#A00D25'" 
                            onmouseout="this.style.backgroundColor='#C8102E'"
                            class="w-full text-white py-2.5 px-4 rounded-lg text-sm font-medium transition-all duration-200">
                        Create Account
                    </button>
                </div>
            </form>
        </div>

        <!-- Alternative Registration -->
        <div class="px-6 py-4 border-t transition-colors duration-200" style="background-color: #f9fafb; border-color: #e5e7eb;">
            <div class="relative">
                <div class="absolute inset-0 flex items-center">
                    <div class="w-full border-t" style="border-color: #e5e7eb;"></div>
                </div>
                <div class="relative flex justify-center text-xs">
                    <span class="px-3" style="background-color: #fef2f2; color: #7D0A1D;">Or continue with</span>
                </div>
            </div>

                    <div class="mt-4 flex justify-center">
                        <a href="{{ route('google.redirect') }}" class="inline-flex items-center justify-center px-3 py-2 border rounded-lg shadow-sm text-xs font-medium transition-colors duration-200" style="border-color: #d1d5db; background-color: white; color: #7D0A1D;" onmouseover="this.style.backgroundColor='#f9fafb'" onmouseout="this.style.backgroundColor='white'">
                            <svg class="h-4 w-4 mr-2" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z" fill="#4285F4"/>
                                <path d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z" fill="#34A853"/>
                                <path d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z" fill="#FBBC05"/>
                                <path d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z" fill="#EA4335"/>
                            </svg>
                            Continue with Google
                        </a>
                    </div>
        </div>

        <!-- Login Link -->
        <div class="px-6 py-4 border-t text-center transition-colors duration-200" style="background-color: #f9fafb; border-color: #e5e7eb;">
            <p class="text-xs" style="color: #7D0A1D;">
                Already have an account?
                <a href="{{ route('login') }}" class="text-[#C8102E] dark:text-white hover:text-[#A00D25] dark:hover:text-blue-200 font-medium transition-colors duration-200">
                    Sign in
                </a>
            </p>
        </div>
    </div>

    <!-- Terms Notice -->
    <div class="mt-6 text-center">
        <p class="text-xs" style="color: #fca5a5;">
            By creating an account, you agree to our 
            <a href="{{ route('terms') }}" class="text-[#C8102E] dark:text-white hover:text-[#A00D25] dark:hover:text-blue-200 transition-colors duration-200">Terms of Service</a> 
            and 
            <a href="{{ route('privacy') }}" class="text-[#C8102E] dark:text-white hover:text-[#A00D25] dark:hover:text-blue-200 transition-colors duration-200">Privacy Policy</a>
        </p>
    </div>

    <script>
        // Populate countries dropdown immediately on page load
        document.addEventListener('DOMContentLoaded', function() {
            // List of countries
            const countries = [
            {code: "AF", name: "Afghanistan"}, {code: "AL", name: "Albania"}, {code: "DZ", name: "Algeria"},
            {code: "AS", name: "American Samoa"}, {code: "AD", name: "Andorra"}, {code: "AO", name: "Angola"},
            {code: "AI", name: "Anguilla"}, {code: "AG", name: "Antigua and Barbuda"}, {code: "AR", name: "Argentina"},
            {code: "AM", name: "Armenia"}, {code: "AW", name: "Aruba"}, {code: "AU", name: "Australia"},
            {code: "AT", name: "Austria"}, {code: "AZ", name: "Azerbaijan"}, {code: "BS", name: "Bahamas"},
            {code: "BH", name: "Bahrain"}, {code: "BD", name: "Bangladesh"}, {code: "BB", name: "Barbados"},
            {code: "BY", name: "Belarus"}, {code: "BE", name: "Belgium"}, {code: "BZ", name: "Belize"},
            {code: "BJ", name: "Benin"}, {code: "BM", name: "Bermuda"}, {code: "BT", name: "Bhutan"},
            {code: "BO", name: "Bolivia"}, {code: "BA", name: "Bosnia and Herzegovina"}, {code: "BW", name: "Botswana"},
            {code: "BR", name: "Brazil"}, {code: "BN", name: "Brunei"}, {code: "BG", name: "Bulgaria"},
            {code: "BF", name: "Burkina Faso"}, {code: "BI", name: "Burundi"}, {code: "KH", name: "Cambodia"},
            {code: "CM", name: "Cameroon"}, {code: "CA", name: "Canada"}, {code: "CV", name: "Cape Verde"},
            {code: "KY", name: "Cayman Islands"}, {code: "CF", name: "Central African Republic"}, {code: "TD", name: "Chad"},
            {code: "CL", name: "Chile"}, {code: "CN", name: "China"}, {code: "CO", name: "Colombia"},
            {code: "KM", name: "Comoros"}, {code: "CG", name: "Congo"}, {code: "CR", name: "Costa Rica"},
            {code: "HR", name: "Croatia"}, {code: "CU", name: "Cuba"}, {code: "CY", name: "Cyprus"},
            {code: "CZ", name: "Czech Republic"}, {code: "DK", name: "Denmark"}, {code: "DJ", name: "Djibouti"},
            {code: "DM", name: "Dominica"}, {code: "DO", name: "Dominican Republic"}, {code: "EC", name: "Ecuador"},
            {code: "EG", name: "Egypt"}, {code: "SV", name: "El Salvador"}, {code: "GQ", name: "Equatorial Guinea"},
            {code: "ER", name: "Eritrea"}, {code: "EE", name: "Estonia"}, {code: "ET", name: "Ethiopia"},
            {code: "FJ", name: "Fiji"}, {code: "FI", name: "Finland"}, {code: "FR", name: "France"},
            {code: "GA", name: "Gabon"}, {code: "GM", name: "Gambia"}, {code: "GE", name: "Georgia"},
            {code: "DE", name: "Germany"}, {code: "GH", name: "Ghana"}, {code: "GR", name: "Greece"},
            {code: "GD", name: "Grenada"}, {code: "GT", name: "Guatemala"}, {code: "GN", name: "Guinea"},
            {code: "GW", name: "Guinea-Bissau"}, {code: "GY", name: "Guyana"}, {code: "HT", name: "Haiti"},
            {code: "HN", name: "Honduras"}, {code: "HK", name: "Hong Kong"}, {code: "HU", name: "Hungary"},
            {code: "IS", name: "Iceland"}, {code: "IN", name: "India"}, {code: "ID", name: "Indonesia"},
            {code: "IR", name: "Iran"}, {code: "IQ", name: "Iraq"}, {code: "IE", name: "Ireland"},
            {code: "IL", name: "Israel"}, {code: "IT", name: "Italy"}, {code: "JM", name: "Jamaica"},
            {code: "JP", name: "Japan"}, {code: "JO", name: "Jordan"}, {code: "KZ", name: "Kazakhstan"},
            {code: "KE", name: "Kenya"}, {code: "KI", name: "Kiribati"}, {code: "KP", name: "North Korea"},
            {code: "KR", name: "South Korea"}, {code: "KW", name: "Kuwait"}, {code: "KG", name: "Kyrgyzstan"},
            {code: "LA", name: "Laos"}, {code: "LV", name: "Latvia"}, {code: "LB", name: "Lebanon"},
            {code: "LS", name: "Lesotho"}, {code: "LR", name: "Liberia"}, {code: "LY", name: "Libya"},
            {code: "LI", name: "Liechtenstein"}, {code: "LT", name: "Lithuania"}, {code: "LU", name: "Luxembourg"},
            {code: "MO", name: "Macau"}, {code: "MK", name: "Macedonia"}, {code: "MG", name: "Madagascar"},
            {code: "MW", name: "Malawi"}, {code: "MY", name: "Malaysia"}, {code: "MV", name: "Maldives"},
            {code: "ML", name: "Mali"}, {code: "MT", name: "Malta"}, {code: "MH", name: "Marshall Islands"},
            {code: "MR", name: "Mauritania"}, {code: "MU", name: "Mauritius"}, {code: "MX", name: "Mexico"},
            {code: "FM", name: "Micronesia"}, {code: "MD", name: "Moldova"}, {code: "MC", name: "Monaco"},
            {code: "MN", name: "Mongolia"}, {code: "ME", name: "Montenegro"}, {code: "MA", name: "Morocco"},
            {code: "MZ", name: "Mozambique"}, {code: "MM", name: "Myanmar"}, {code: "NA", name: "Namibia"},
            {code: "NR", name: "Nauru"}, {code: "NP", name: "Nepal"}, {code: "NL", name: "Netherlands"},
            {code: "NZ", name: "New Zealand"}, {code: "NI", name: "Nicaragua"}, {code: "NE", name: "Niger"},
            {code: "NG", name: "Nigeria"}, {code: "NO", name: "Norway"}, {code: "OM", name: "Oman"},
            {code: "PK", name: "Pakistan"}, {code: "PW", name: "Palau"}, {code: "PS", name: "Palestine"},
            {code: "PA", name: "Panama"}, {code: "PG", name: "Papua New Guinea"}, {code: "PY", name: "Paraguay"},
            {code: "PE", name: "Peru"}, {code: "PH", name: "Philippines"}, {code: "PL", name: "Poland"},
            {code: "PT", name: "Portugal"}, {code: "PR", name: "Puerto Rico"}, {code: "QA", name: "Qatar"},
            {code: "RO", name: "Romania"}, {code: "RU", name: "Russia"}, {code: "RW", name: "Rwanda"},
            {code: "KN", name: "Saint Kitts and Nevis"}, {code: "LC", name: "Saint Lucia"}, {code: "VC", name: "Saint Vincent"},
            {code: "WS", name: "Samoa"}, {code: "SM", name: "San Marino"}, {code: "ST", name: "Sao Tome and Principe"},
            {code: "SA", name: "Saudi Arabia"}, {code: "SN", name: "Senegal"}, {code: "RS", name: "Serbia"},
            {code: "SC", name: "Seychelles"}, {code: "SL", name: "Sierra Leone"}, {code: "SG", name: "Singapore"},
            {code: "SK", name: "Slovakia"}, {code: "SI", name: "Slovenia"}, {code: "SB", name: "Solomon Islands"},
            {code: "SO", name: "Somalia"}, {code: "ZA", name: "South Africa"}, {code: "SS", name: "South Sudan"},
            {code: "ES", name: "Spain"}, {code: "LK", name: "Sri Lanka"}, {code: "SD", name: "Sudan"},
            {code: "SR", name: "Suriname"}, {code: "SZ", name: "Swaziland"}, {code: "SE", name: "Sweden"},
            {code: "CH", name: "Switzerland"}, {code: "SY", name: "Syria"}, {code: "TW", name: "Taiwan"},
            {code: "TJ", name: "Tajikistan"}, {code: "TZ", name: "Tanzania"}, {code: "TH", name: "Thailand"},
            {code: "TL", name: "Timor-Leste"}, {code: "TG", name: "Togo"}, {code: "TO", name: "Tonga"},
            {code: "TT", name: "Trinidad and Tobago"}, {code: "TN", name: "Tunisia"}, {code: "TR", name: "Turkey"},
            {code: "TM", name: "Turkmenistan"}, {code: "TV", name: "Tuvalu"}, {code: "UG", name: "Uganda"},
            {code: "UA", name: "Ukraine"}, {code: "AE", name: "United Arab Emirates"}, {code: "GB", name: "United Kingdom"},
            {code: "US", name: "United States"}, {code: "UY", name: "Uruguay"}, {code: "UZ", name: "Uzbekistan"},
            {code: "VU", name: "Vanuatu"}, {code: "VA", name: "Vatican City"}, {code: "VE", name: "Venezuela"},
            {code: "VN", name: "Vietnam"}, {code: "YE", name: "Yemen"}, {code: "ZM", name: "Zambia"},
            {code: "ZW", name: "Zimbabwe"}
        ];

            // Populate countries dropdown
            const countrySelect = document.getElementById('country');
            const oldCountry = '{{ old("country") }}';
            
            countries.forEach(country => {
                const option = document.createElement('option');
                option.value = country.code;
                option.textContent = country.name;
                if (country.code === oldCountry) {
                    option.selected = true;
                }
                countrySelect.appendChild(option);
            });
        });
    </script>
</x-guest-layout>
