<x-guest-layout>
    <x-slot name="title">Sign In</x-slot>

    <div class="bg-white rounded-xl shadow-sm border overflow-hidden transition-colors duration-200" style="background-color: white; border-color: #e5e7eb;">
        <!-- Enhanced Header -->
        <div class="px-6 py-6 text-center">
            <h1 class="text-xl font-light mb-1" style="color: #C8102E;">Sign In</h1>
            <p class="text-xs" style="color: #7D0A1D;">Access your Tesla Drives account</p>
        </div>

        <!-- Session Status -->
        @if (session('status'))
            <div class="bg-green-50 border-l-4 border-green-500 p-3 mb-4 mx-6">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <i data-lucide="check-circle" class="w-4 h-4 text-green-500"></i>
                    </div>
                    <div class="ml-3">
                        <p class="text-xs text-green-700">{{ session('status') }}</p>
                    </div>
                </div>
            </div>
        @endif

        <!-- Login Form -->
        <div class="px-6 pb-6">
            <form method="POST" action="{{ route('login') }}" class="space-y-4">
                @csrf

                <!-- Email Address -->
                <div>
                    <label for="email" class="block text-xs font-medium text-[#C8102E] dark:text-white mb-1">Email</label>
                    <input type="email" 
                           id="email" 
                           name="email" 
                           value="{{ old('email') }}" 
                           required 
                           autofocus 
                           autocomplete="username" 
                           style="border-color: #d1d5db;"
                           class="w-full px-3 py-2.5 border rounded-lg focus:outline-none focus:ring-2 focus:border-transparent transition-colors duration-200 @error('email') border-red-500 @enderror"
                           onfocus="this.style.borderColor='#C8102E'; this.style.outline='2px solid #C8102E';"
                           onblur="this.style.borderColor='#d1d5db'; this.style.outline='none';">
                    @error('email')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Password -->
                <div>
                    <div class="flex items-center justify-between mb-1">
                        <label for="password" class="block text-xs font-medium text-[#C8102E] dark:text-white">Password</label>
                        @if (Route::has('password.request'))
                            <a href="{{ route('password.request') }}" class="text-xs transition-colors duration-200" style="color: #7D0A1D;" onmouseover="this.style.color='#C8102E'" onmouseout="this.style.color='#7D0A1D'">
                                Forgot password?
                            </a>
                        @endif
                    </div>
                    <div class="relative">
                        <input type="password" 
                               id="password" 
                               name="password" 
                               required 
                               autocomplete="current-password" 
                               style="border-color: #d1d5db;"
                               class="w-full px-3 py-2.5 pr-10 border rounded-lg focus:outline-none focus:ring-2 focus:border-transparent transition-colors duration-200 @error('password') border-red-500 @enderror"
                               onfocus="this.style.borderColor='#C8102E'; this.style.outline='2px solid #C8102E';"
                               onblur="this.style.borderColor='#d1d5db'; this.style.outline='none';">
                        <button type="button" 
                                onclick="togglePassword()" 
                                class="absolute inset-y-0 right-0 flex items-center pr-3 transition-colors" style="color: #fca5a5;" onmouseover="this.style.color='#C8102E'" onmouseout="this.style.color='#fca5a5'">
                            <svg id="password-show-icon" class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                            </svg>
                            <svg id="password-hide-icon" class="w-4 h-4 hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.878 9.878L3 3m6.878 6.878L21 21"></path>
                            </svg>
                        </button>
                    </div>
                    @error('password')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Remember Me -->
                <div class="flex items-center">
                    <input type="checkbox" 
                           id="remember_me" 
                           name="remember" 
                           style="accent-color: #C8102E; border-color: #d1d5db;"
                           class="w-3.5 h-3.5 border rounded">
                    <label for="remember_me" class="ml-2 text-xs" style="color: #7D0A1D;">
                        Remember me
                    </label>
                </div>

                <!-- Submit Button -->
                <div class="pt-2">
                    <button type="submit" 
                            style="background-color: #C8102E;" 
                            onmouseover="this.style.backgroundColor='#A00D25'" 
                            onmouseout="this.style.backgroundColor='#C8102E'"
                            class="w-full text-white py-2.5 px-4 rounded-lg text-sm font-medium transition-all duration-200">
                        Sign In
                    </button>
                </div>
            </form>
        </div>

        <!-- Registration Link -->
        <div class="px-6 py-4 border-t text-center transition-colors duration-200" style="background-color: #f9fafb; border-color: #e5e7eb;">
            <p class="text-xs" style="color: #7D0A1D;">
                Don't have an account?
                <a href="{{ route('register') }}" class="text-[#C8102E] dark:text-white hover:text-[#A00D25] dark:hover:text-blue-200 font-medium transition-colors duration-200">
                    Create account
                </a>
            </p>
        </div>
    </div>

    <!-- Alternative Sign In -->
    <div class="mt-6">
        <div class="relative">
            <div class="absolute inset-0 flex items-center">
                <div class="w-full border-t" style="border-color: #e5e7eb;"></div>
            </div>
            <div class="relative flex justify-center text-xs">
                <span class="px-3" style="background-color: #fef2f2; color: #7D0A1D;">Or continue with</span>
            </div>
        </div>

        <div class="mt-4 flex justify-center">
            <a href="{{ route('google.redirect') }}" class="inline-flex items-center justify-center px-3 py-2 border rounded-lg shadow-sm text-xs font-medium transition-colors duration-200" style="border-color: #d1d5db; background-color: white; color: #7D0A1D;" onmouseover="this.style.backgroundColor='#f9fafb'" onmouseout="this.style.backgroundColor='white'">
                <svg class="h-4 w-4 mr-2" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z" fill="#4285F4"/>
                    <path d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z" fill="#34A853"/>
                    <path d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z" fill="#FBBC05"/>
                    <path d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z" fill="#EA4335"/>
                </svg>
                Continue with Google
            </a>
        </div>
    </div>

    <!-- Security Notice -->
    <div class="mt-6 text-center">
        <div class="flex items-center justify-center text-xs" style="color: #fca5a5;">
            <i data-lucide="shield" class="w-3 h-3 mr-1"></i>
            Secure login protected by SSL encryption
        </div>
    </div>

    <script>
        function togglePassword() {
            const passwordInput = document.getElementById('password');
            const showIcon = document.getElementById('password-show-icon');
            const hideIcon = document.getElementById('password-hide-icon');
            
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                showIcon.classList.add('hidden');
                hideIcon.classList.remove('hidden');
            } else {
                passwordInput.type = 'password';
                showIcon.classList.remove('hidden');
                hideIcon.classList.add('hidden');
            }
        }
    </script>
</x-guest-layout>
