<x-guest-layout>
    <x-slot name="title">Reset Password</x-slot>

    <div class="bg-white rounded-xl shadow-sm border overflow-hidden" style="background-color: white; border-color: #e5e7eb;">
        <!-- Enhanced Header -->
        <div class="px-6 py-6 text-center">
            <h1 class="text-xl font-light mb-1" style="color: #C8102E;">Reset Password</h1>
            <p class="text-xs" style="color: #7D0A1D;">Enter your email to receive a reset link</p>
        </div>

        <!-- Session Status -->
        @if (session('status'))
            <div class="bg-green-50 border-l-4 border-green-500 p-3 mb-4 mx-6">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <i data-lucide="check-circle" class="w-4 h-4 text-green-500"></i>
                    </div>
                    <div class="ml-3">
                        <p class="text-xs text-green-700">{{ session('status') }}</p>
                    </div>
                </div>
            </div>
        @endif

        <!-- Reset Form -->
        <div class="px-6 pb-6">
            <div class="mb-4 text-xs text-center" style="color: #7D0A1D;">
                Forgot your password? No problem. Just let us know your email address and we will email you a password reset link that will allow you to choose a new one.
            </div>

            <form method="POST" action="{{ route('password.email') }}" class="space-y-4">
                @csrf

                <!-- Email Address -->
                <div>
                    <label for="email" class="block text-xs font-medium text-[#C8102E] dark:text-white mb-1">Email</label>
                    <input type="email" 
                           id="email" 
                           name="email" 
                           value="{{ old('email') }}" 
                           required 
                           autofocus 
                           style="border-color: #d1d5db;"
                           class="w-full px-3 py-2.5 border rounded-lg focus:outline-none focus:ring-2 focus:border-transparent transition-colors duration-200 @error('email') border-red-500 @enderror"
                           onfocus="this.style.borderColor='#C8102E'; this.style.outline='2px solid #C8102E';"
                           onblur="this.style.borderColor='#d1d5db'; this.style.outline='none';">
                    @error('email')
                        <p class="mt-1 text-xs text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Submit Button -->
                <div class="pt-2">
                    <button type="submit" 
                            style="background-color: #C8102E;" 
                            onmouseover="this.style.backgroundColor='#A00D25'" 
                            onmouseout="this.style.backgroundColor='#C8102E'"
                            class="w-full text-white py-2.5 px-4 rounded-lg text-sm font-medium transition-all duration-200">
                        Email Password Reset Link
                    </button>
                </div>
            </form>
        </div>

        <!-- Back to Login Link -->
        <div class="px-6 py-4 border-t text-center" style="background-color: #f9fafb; border-color: #e5e7eb;">
            <p class="text-xs" style="color: #7D0A1D;">
                Remember your password?
                <a href="{{ route('login') }}" class="text-[#C8102E] hover:text-[#A00D25] font-medium transition-colors duration-200">
                    Sign in
                </a>
            </p>
        </div>
    </div>
</x-guest-layout>
