<x-guest-layout>
    <x-slot name="title">Confirm Password</x-slot>

    <div class="bg-white rounded-lg shadow-sm border overflow-hidden" style="background-color: white; border-color: #e5e7eb;">
        <!-- Header -->
        <div class="px-8 py-8 text-center">
            <h1 class="text-3xl font-light mb-2" style="color: #C8102E;">Confirm Password</h1>
            <p style="color: #7D0A1D;">This is a secure area of the application</p>
        </div>

        <!-- Confirm Form -->
        <div class="px-8 pb-8">
            <div class="mb-6 text-sm text-center" style="color: #7D0A1D;">
                Please confirm your password before continuing.
            </div>

            <form method="POST" action="{{ route('password.confirm') }}" class="space-y-6">
                @csrf

                <!-- Password -->
                <div>
                    <label for="password" class="block text-sm font-medium text-[#C8102E] dark:text-white mb-2">Password</label>
                    <input type="password" 
                           id="password" 
                           name="password" 
                           required 
                           autocomplete="current-password" 
                           style="border-color: #d1d5db;"
                           class="w-full px-4 py-3 border rounded-md focus:outline-none focus:ring-1 transition-colors duration-200 @error('password') border-red-500 @enderror"
                           onfocus="this.style.borderColor='#C8102E'; this.style.outline='1px solid #C8102E';"
                           onblur="this.style.borderColor='#d1d5db'; this.style.outline='none';">
                    @error('password')
                        <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Submit Button -->
                <div class="pt-4">
                    <button type="submit" 
                            style="background-color: #C8102E;" 
                            onmouseover="this.style.backgroundColor='#A00D25'" 
                            onmouseout="this.style.backgroundColor='#C8102E'"
                            class="w-full text-white py-3 px-6 rounded-md text-base font-medium transition-all duration-200">
                        Confirm
                    </button>
                </div>
            </form>
        </div>

        <!-- Back Link -->
        <div class="px-8 py-6 border-t text-center" style="background-color: #f9fafb; border-color: #e5e7eb;">
            <p class="text-sm" style="color: #7D0A1D;">
                <a href="{{ route('dashboard') }}" class="text-[#C8102E] hover:text-[#A00D25] font-medium transition-colors duration-200">
                    Back to Dashboard
                </a>
            </p>
        </div>
    </div>
</x-guest-layout>
