<x-admin-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <div>
                <h2 class="font-light text-lg text-black leading-tight mr-4">
                    Stock Management
                </h2>
            </div>
        </div>
    </x-slot>

    <div class="py-6">
        <div class="max-w-8xl mx-auto sm:px-6 lg:px-8">
            <!-- Statistics Overview -->
            <div class="grid grid-cols-2 md:grid-cols-5 gap-4 mb-6">
                <div class="bg-white border border-gray-200 dark:border-blue-600 p-4 rounded-lg">
                    <div class="flex items-center">
                        <div class="w-8 h-8 md:w-10 md:h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                            <svg class="w-4 h-4 md:w-5 md:h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                            </svg>
                        </div>
                        <div class="ml-2 md:ml-3">
                            <p class="text-xs font-medium text-gray-600 dark:text-blue-100">Total Stocks</p>
                            <p class="text-sm md:text-lg font-light text-black">{{ $stats['total_stocks'] }}</p>
                        </div>
                    </div>
                </div>

                <div class="bg-white border border-gray-200 dark:border-blue-600 p-4 rounded-lg">
                    <div class="flex items-center">
                        <div class="w-8 h-8 md:w-10 md:h-10 bg-green-100 rounded-lg flex items-center justify-center">
                            <svg class="w-4 h-4 md:w-5 md:h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                        <div class="ml-2 md:ml-3">
                            <p class="text-xs font-medium text-gray-600 dark:text-blue-100">Active Stocks</p>
                            <p class="text-sm md:text-lg font-light text-black">{{ $stats['active_stocks'] }}</p>
                        </div>
                    </div>
                </div>

                <div class="bg-white border border-gray-200 dark:border-blue-600 p-4 rounded-lg">
                    <div class="flex items-center">
                        <div class="w-8 h-8 md:w-10 md:h-10 bg-purple-100 rounded-lg flex items-center justify-center">
                            <svg class="w-4 h-4 md:w-5 md:h-5 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"></path>
                            </svg>
                        </div>
                        <div class="ml-2 md:ml-3">
                            <p class="text-xs font-medium text-gray-600 dark:text-blue-100">With Holdings</p>
                            <p class="text-sm md:text-lg font-light text-black">{{ $stats['stocks_with_holdings'] }}</p>
                        </div>
                    </div>
                </div>

                <div class="bg-white border border-gray-200 dark:border-blue-600 p-4 rounded-lg">
                    <div class="flex items-center">
                        <div class="w-8 h-8 md:w-10 md:h-10 bg-yellow-100 rounded-lg flex items-center justify-center">
                            <svg class="w-4 h-4 md:w-5 md:h-5 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                            </svg>
                        </div>
                        <div class="ml-2 md:ml-3">
                            <p class="text-xs font-medium text-gray-600 dark:text-blue-100">Total Holdings</p>
                            <p class="text-sm md:text-lg font-light text-black">{{ $stats['total_holdings'] }}</p>
                        </div>
                    </div>
                </div>

                <div class="bg-white border border-gray-200 dark:border-blue-600 p-4 rounded-lg">
                    <div class="flex items-center">
                        <div class="w-8 h-8 md:w-10 md:h-10 bg-red-100 rounded-lg flex items-center justify-center">
                            <svg class="w-4 h-4 md:w-5 md:h-5 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"></path>
                            </svg>
                        </div>
                        <div class="ml-2 md:ml-3">
                            <p class="text-xs font-medium text-gray-600 dark:text-blue-100">Transactions</p>
                            <p class="text-sm md:text-lg font-light text-black">{{ $stats['total_transactions'] }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Stocks List -->
            <div class="bg-white border border-gray-200 dark:border-blue-600 overflow-hidden rounded-lg">
                <div class="px-4 py-3 border-b border-gray-200 dark:border-blue-600 bg-gray-50">
                    <h3 class="text-base font-medium text-black">Available Stocks</h3>
                    <p class="text-xs text-gray-600 mt-1">All stocks available for trading</p>
                </div>
                
                <div class="p-4">
                    @if($stocks->count() > 0)
                    <div class="space-y-4">
                        @foreach($stocks as $stock)
                        <div class="border border-gray-200 dark:border-blue-600 rounded-lg p-4 hover:bg-gray-50 transition-colors">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center space-x-3">
                                    @if($stock->logo_url)
                                        <div class="w-12 h-12 rounded-lg flex items-center justify-center bg-white border border-gray-200 dark:border-blue-600">
                                            <img src="{{ $stock->logo_url }}" alt="{{ $stock->symbol }} Logo" class="w-10 h-10 object-contain" loading="lazy">
                                        </div>
                                    @else
                                        <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-purple-600 rounded-lg flex items-center justify-center">
                                            <span class="text-white font-bold text-sm">{{ $stock->symbol }}</span>
                                        </div>
                                    @endif
                                    <div>
                                        <h4 class="text-sm font-medium text-black">{{ $stock->name }}</h4>
                                        <p class="text-xs text-gray-600 dark:text-blue-100">{{ $stock->symbol }} • {{ $stock->sector }}</p>
                                        <p class="text-xs text-gray-500 dark:text-blue-200">{{ $stock->holdings_count }} holdings • {{ $stock->transactions_count }} transactions</p>
                                    </div>
                                </div>
                                
                                <div class="flex items-center space-x-3">
                                    <div class="text-right">
                                        <p class="text-xs text-gray-600 dark:text-blue-100">Current Price</p>
                                        <p class="text-sm font-medium text-black">${{ number_format($stock->current_price, 2) }}</p>
                                        @if($stock->price_change_percentage)
                                            <p class="text-xs {{ $stock->price_change_percentage >= 0 ? 'text-green-600' : 'text-red-600' }}">
                                                {{ $stock->price_change_percentage >= 0 ? '+' : '' }}{{ number_format($stock->price_change_percentage, 2) }}%
                                            </p>
                                        @endif
                                        @if($stock->last_updated)
                                            <p class="text-xs text-gray-500 dark:text-blue-200">{{ $stock->last_updated->diffForHumans() }}</p>
                                        @endif
                                    </div>
                                    
                                    <div class="flex space-x-2">
                                        <a href="{{ route('admin.stocks.show', $stock) }}" 
                                           class="px-3 py-1.5 bg-black dark:bg-white text-white dark:text-blue-900 text-xs font-medium rounded hover:bg-gray-800 dark:hover:bg-blue-50 transition-colors">
                                            View
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    @else
                    <div class="text-center py-8">
                        <div class="w-16 h-16 bg-gray-100 dark:bg-blue-600 rounded-full flex items-center justify-center mx-auto mb-4">
                            <svg class="w-8 h-8 text-gray-400 dark:text-blue-200" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                            </svg>
                        </div>
                        <h3 class="text-lg font-medium text-black dark:text-white mb-2">No stocks found</h3>
                        <p class="text-xs text-gray-500 dark:text-blue-200">There are no stocks available at the moment.</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
