<x-admin-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <div>
                <h2 class="font-light text-lg text-black leading-tight mr-4">
                    Stock Transaction Details
                </h2>
            </div>
            <div class="flex space-x-2">
                <a href="{{ route('admin.stocks.transactions.index') }}" 
                   class="px-3 py-2 bg-gray-100 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-200 transition-colors">
                    Back to Transactions
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-6">
        <div class="max-w-6xl mx-auto sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 xl:grid-cols-3 gap-6">
                <!-- Main Content -->
                <div class="xl:col-span-2 space-y-6">
                    <!-- Transaction Overview -->
                    <div class="bg-white border border-gray-200 dark:border-blue-600 overflow-hidden rounded-lg">
                        <div class="px-4 py-3 border-b border-gray-200 dark:border-blue-600 bg-gray-50">
                            <h3 class="text-base font-medium text-black">Transaction Overview</h3>
                        </div>
                        <div class="p-4">
                            <div class="flex items-start space-x-4 mb-4">
                                @if($transaction->stock->logo_url)
                                    <div class="w-16 h-16 rounded-lg flex items-center justify-center bg-white border border-gray-200 dark:border-blue-600">
                                        <img src="{{ $transaction->stock->logo_url }}" alt="{{ $transaction->stock->symbol }} Logo" class="w-14 h-14 object-contain" loading="lazy">
                                    </div>
                                @else
                                    <div class="w-16 h-16 bg-gradient-to-br from-blue-500 to-purple-600 rounded-lg flex items-center justify-center">
                                        <span class="text-white font-bold text-lg">{{ $transaction->stock->symbol }}</span>
                                    </div>
                                @endif
                                <div class="flex-1">
                                    <h4 class="text-lg font-medium text-black dark:text-white mb-2">{{ $transaction->stock->name }}</h4>
                                    <p class="text-sm text-gray-600 mb-3">{{ $transaction->stock->description }}</p>
                                    <div class="flex flex-wrap gap-2">
                                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium {{ $transaction->type === 'buy' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                            {{ ucfirst($transaction->type) }}
                                        </span>
                                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium {{ $transaction->status === 'completed' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                                            {{ ucfirst($transaction->status) }}
                                        </span>
                                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                            {{ $transaction->stock->sector }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Transaction Metrics -->
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                        <div class="bg-white border border-gray-200 dark:border-blue-600 p-4 rounded-lg">
                            <div class="text-center">
                                <p class="text-xs font-medium text-gray-600 mb-1">Shares</p>
                                <p class="text-lg font-light text-black">{{ number_format($transaction->quantity, 2) }}</p>
                            </div>
                        </div>

                        <div class="bg-white border border-gray-200 dark:border-blue-600 p-4 rounded-lg">
                            <div class="text-center">
                                <p class="text-xs font-medium text-gray-600 mb-1">Price per Share</p>
                                <p class="text-lg font-light text-black">${{ number_format($transaction->price_per_share, 2) }}</p>
                            </div>
                        </div>

                        <div class="bg-white border border-gray-200 dark:border-blue-600 p-4 rounded-lg">
                            <div class="text-center">
                                <p class="text-xs font-medium text-gray-600 mb-1">Total Amount</p>
                                <p class="text-lg font-light text-black">${{ number_format($transaction->total_amount, 2) }}</p>
                            </div>
                        </div>

                        <div class="bg-white border border-gray-200 dark:border-blue-600 p-4 rounded-lg">
                            <div class="text-center">
                                <p class="text-xs font-medium text-gray-600 mb-1">Transaction Date</p>
                                <p class="text-lg font-light text-black">{{ $transaction->created_at->format('M d, Y') }}</p>
                            </div>
                        </div>
                    </div>

                    <!-- Stock Information -->
                    <div class="bg-white border border-gray-200 dark:border-blue-600 overflow-hidden rounded-lg">
                        <div class="px-4 py-3 border-b border-gray-200 dark:border-blue-600 bg-gray-50">
                            <h3 class="text-base font-medium text-black">Stock Information</h3>
                        </div>
                        <div class="p-4">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-xs font-medium text-gray-500 dark:text-blue-100 mb-1">Current Price</label>
                                    <p class="text-sm font-medium text-black">${{ number_format($transaction->stock->current_price, 2) }}</p>
                                </div>
                                <div>
                                    <label class="block text-xs font-medium text-gray-500 dark:text-blue-100 mb-1">Previous Close</label>
                                    <p class="text-sm font-medium text-black">${{ number_format($transaction->stock->previous_close, 2) }}</p>
                                </div>
                                <div>
                                    <label class="block text-xs font-medium text-gray-500 dark:text-blue-100 mb-1">Price Change</label>
                                    <p class="text-sm font-medium {{ $transaction->stock->price_change >= 0 ? 'text-green-600' : 'text-red-600' }}">
                                        {{ $transaction->stock->price_change >= 0 ? '+' : '' }}${{ number_format($transaction->stock->price_change, 2) }}
                                    </p>
                                </div>
                                <div>
                                    <label class="block text-xs font-medium text-gray-500 dark:text-blue-100 mb-1">Price Change %</label>
                                    <p class="text-sm font-medium {{ $transaction->stock->price_change_percentage >= 0 ? 'text-green-600' : 'text-red-600' }}">
                                        {{ $transaction->stock->price_change_percentage >= 0 ? '+' : '' }}{{ number_format($transaction->stock->price_change_percentage, 2) }}%
                                    </p>
                                </div>
                                <div>
                                    <label class="block text-xs font-medium text-gray-500 dark:text-blue-100 mb-1">Sector</label>
                                    <p class="text-sm font-medium text-black">{{ $transaction->stock->sector }}</p>
                                </div>
                                <div>
                                    <label class="block text-xs font-medium text-gray-500 dark:text-blue-100 mb-1">Industry</label>
                                    <p class="text-sm font-medium text-black">{{ $transaction->stock->industry }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Sidebar -->
                <div class="space-y-6">
                    <!-- User Information -->
                    <div class="bg-white border border-gray-200 dark:border-blue-600 overflow-hidden rounded-lg">
                        <div class="px-4 py-3 border-b border-gray-200 dark:border-blue-600 bg-gray-50">
                            <h3 class="text-base font-medium text-black">User Information</h3>
                        </div>
                        <div class="p-4">
                            <div class="flex items-center space-x-3 mb-4">
                                @if($transaction->user->profile_image)
                                    <img src="{{ asset('uploads/' . $transaction->user->profile_image) }}" 
                                         alt="{{ $transaction->user->name }}" 
                                         class="w-12 h-12 rounded-lg object-cover">
                                @else
                                    <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-purple-600 rounded-lg flex items-center justify-center">
                                        <span class="text-white font-bold text-sm">{{ strtoupper(substr($transaction->user->name, 0, 2)) }}</span>
                                    </div>
                                @endif
                                <div>
                                    <h4 class="text-sm font-medium text-black">{{ $transaction->user->name }}</h4>
                                    <p class="text-xs text-gray-600 dark:text-blue-100">{{ $transaction->user->email }}</p>
                                </div>
                            </div>
                            
                            <div class="space-y-3">
                                <div>
                                    <label class="block text-xs font-medium text-gray-500 dark:text-blue-100 mb-1">Member Since</label>
                                    <p class="text-sm font-medium text-black">{{ $transaction->user->created_at->format('M d, Y') }}</p>
                                </div>
                                <div>
                                    <label class="block text-xs font-medium text-gray-500 dark:text-blue-100 mb-1">Email Status</label>
                                    <p class="text-sm font-medium text-black">
                                        @if($transaction->user->email_verified_at)
                                            <span class="text-green-600">Verified</span>
                                        @else
                                            <span class="text-red-600">Unverified</span>
                                        @endif
                                    </p>
                                </div>
                            </div>

                            <div class="mt-4">
                                <a href="{{ route('admin.users.show', $transaction->user) }}" 
                                   class="w-full inline-flex items-center justify-center px-3 py-2 bg-black dark:bg-white text-white dark:text-blue-900 text-sm font-medium rounded-lg hover:bg-gray-800 dark:hover:bg-blue-50 transition-colors">
                                   <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                       <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                   </svg>
                                   View User Profile
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Transaction Details -->
                    <div class="bg-white border border-gray-200 dark:border-blue-600 overflow-hidden rounded-lg">
                        <div class="px-4 py-3 border-b border-gray-200 dark:border-blue-600 bg-gray-50">
                            <h3 class="text-base font-medium text-black">Transaction Details</h3>
                        </div>
                        <div class="p-4">
                            <div class="space-y-3">
                                <div>
                                    <label class="block text-xs font-medium text-gray-500 dark:text-blue-100 mb-1">Transaction ID</label>
                                    <p class="text-sm font-medium text-black">{{ $transaction->id }}</p>
                                </div>
                                <div>
                                    <label class="block text-xs font-medium text-gray-500 dark:text-blue-100 mb-1">Type</label>
                                    <p class="text-sm font-medium text-black">
                                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium {{ $transaction->type === 'buy' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                            {{ ucfirst($transaction->type) }}
                                        </span>
                                    </p>
                                </div>
                                <div>
                                    <label class="block text-xs font-medium text-gray-500 dark:text-blue-100 mb-1">Status</label>
                                    <p class="text-sm font-medium text-black">
                                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium {{ $transaction->status === 'completed' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                                            {{ ucfirst($transaction->status) }}
                                        </span>
                                    </p>
                                </div>
                                <div>
                                    <label class="block text-xs font-medium text-gray-500 dark:text-blue-100 mb-1">Created</label>
                                    <p class="text-sm font-medium text-black">{{ $transaction->created_at->format('M d, Y h:i A') }}</p>
                                </div>
                                <div>
                                    <label class="block text-xs font-medium text-gray-500 dark:text-blue-100 mb-1">Updated</label>
                                    <p class="text-sm font-medium text-black">{{ $transaction->updated_at->format('M d, Y h:i A') }}</p>
                                </div>
                            </div>

                            <div class="mt-4 space-y-2">
                                <a href="{{ route('admin.stocks.show', $transaction->stock) }}" 
                                   class="w-full inline-flex items-center justify-center px-3 py-2 bg-gray-100 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-200 transition-colors">
                                   <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                       <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                                   </svg>
                                   View Stock Details
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Payment Information -->
                    @if($transaction->walletTransaction)
                    <div class="bg-white border border-gray-200 dark:border-blue-600 overflow-hidden rounded-lg">
                        <div class="px-4 py-3 border-b border-gray-200 dark:border-blue-600 bg-gray-50">
                            <h3 class="text-base font-medium text-black">Payment Information</h3>
                        </div>
                        <div class="p-4">
                            <div class="space-y-3">
                                <div>
                                    <label class="block text-xs font-medium text-gray-500 dark:text-blue-100 mb-1">Payment Method</label>
                                    <p class="text-sm font-medium text-black">{{ $transaction->walletTransaction->paymentMethod->name ?? 'N/A' }}</p>
                                </div>
                                <div>
                                    <label class="block text-xs font-medium text-gray-500 dark:text-blue-100 mb-1">Transaction Reference</label>
                                    <p class="text-sm font-medium text-black">{{ $transaction->walletTransaction->reference_id ?? 'N/A' }}</p>
                                </div>
                                <div>
                                    <label class="block text-xs font-medium text-gray-500 dark:text-blue-100 mb-1">Payment Status</label>
                                    <p class="text-sm font-medium text-black">
                                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium {{ $transaction->walletTransaction->status === 'completed' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                                            {{ ucfirst($transaction->walletTransaction->status) }}
                                        </span>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>
