<x-admin-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-light text-lg text-black leading-tight">
                Membership Tiers
            </h2>
            <a href="{{ route('admin.memberships.tiers.create') }}" class="bg-black text-white px-4 py-2 rounded-lg hover:bg-gray-800 transition-colors text-sm">
                Create New Tier
            </a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white border border-gray-200 rounded-lg p-6">
                @if($tiers->count() > 0)
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead>
                                <tr class="bg-gray-50">
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tier</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Price</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Duration</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Benefits</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @foreach($tiers as $tier)
                                <tr class="hover:bg-gray-50">
                                    <td class="px-4 py-4 whitespace-nowrap">
                                        <div class="text-sm font-medium text-black">{{ $tier->name }}</div>
                                        <div class="text-xs text-gray-500">Order: {{ $tier->sort_order }}</div>
                                    </td>
                                    <td class="px-4 py-4 whitespace-nowrap">
                                        <div class="text-sm text-black font-medium">{{ $tier->formatted_price }}</div>
                                    </td>
                                    <td class="px-4 py-4 whitespace-nowrap">
                                        <div class="text-sm text-black">{{ $tier->duration_days }} days</div>
                                        <div class="text-xs text-gray-500">(~{{ $tier->duration_in_months }} months)</div>
                                    </td>
                                    <td class="px-4 py-4">
                                        <div class="text-xs space-y-1">
                                            <div>🚗 Car Discount: {{ $tier->car_discount_percentage }}%</div>
                                            <div>📈 Investment Bonus: {{ $tier->investment_bonus_percentage }}%</div>
                                            <div>🎁 Giveaway: {{ $tier->giveaway_entry_multiplier }}x entries</div>
                                            @if($tier->priority_support)
                                                <div>⭐ Priority Support</div>
                                            @endif
                                        </div>
                                    </td>
                                    <td class="px-4 py-4 whitespace-nowrap">
                                        <form action="{{ route('admin.memberships.tiers.toggle', $tier) }}" method="POST">
                                            @csrf
                                            @method('PATCH')
                                            <button type="submit" class="inline-flex items-center px-2 py-1 text-xs font-medium rounded {{ $tier->is_active ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                                                {{ $tier->is_active ? 'Active' : 'Inactive' }}
                                            </button>
                                        </form>
                                    </td>
                                    <td class="px-4 py-4 whitespace-nowrap text-sm">
                                        <a href="{{ route('admin.memberships.tiers.edit', $tier) }}" class="text-black hover:text-gray-600 mr-3">Edit</a>
                                        <form action="{{ route('admin.memberships.tiers.destroy', $tier) }}" method="POST" class="inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-red-600 hover:text-red-800" onclick="return confirm('Are you sure?')">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-6">
                        {{ $tiers->links() }}
                    </div>
                @else
                    <div class="text-center py-12">
                        <p class="text-gray-500 text-sm mb-4">No membership tiers found.</p>
                        <a href="{{ route('admin.memberships.tiers.create') }}" class="bg-black text-white px-4 py-2 rounded-lg hover:bg-gray-800 transition-colors text-sm inline-block">
                            Create First Tier
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</x-admin-layout>
