<x-admin-layout>
    <x-slot name="header">
        <h2 class="font-light text-lg text-black leading-tight">
            Create Membership Tier
        </h2>
    </x-slot>

    <div class="py-8">
        <div class="max-w-3xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white border border-gray-200 rounded-lg p-6">
                <form action="{{ route('admin.memberships.tiers.store') }}" method="POST">
                    @csrf

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="md:col-span-2">
                            <label for="name" class="block text-sm font-medium text-black mb-2">Tier Name*</label>
                            <input type="text" name="name" id="name" value="{{ old('name') }}" required
                                   class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">
                            @error('name')<span class="text-red-500 text-xs">{{ $message }}</span>@enderror
                        </div>

                        <div class="md:col-span-2">
                            <label for="description" class="block text-sm font-medium text-black mb-2">Description</label>
                            <textarea name="description" id="description" rows="3"
                                      class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">{{ old('description') }}</textarea>
                            @error('description')<span class="text-red-500 text-xs">{{ $message }}</span>@enderror
                        </div>

                        <div>
                            <label for="price" class="block text-sm font-medium text-black mb-2">Price*</label>
                            <input type="number" name="price" id="price" value="{{ old('price') }}" step="0.01" min="0" required
                                   class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">
                            @error('price')<span class="text-red-500 text-xs">{{ $message }}</span>@enderror
                        </div>

                        <div>
                            <label for="duration_days" class="block text-sm font-medium text-black mb-2">Duration (Days)*</label>
                            <input type="number" name="duration_days" id="duration_days" value="{{ old('duration_days', 365) }}" min="1" required
                                   class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">
                            @error('duration_days')<span class="text-red-500 text-xs">{{ $message }}</span>@enderror
                        </div>

                        <div>
                            <label for="car_discount_percentage" class="block text-sm font-medium text-black mb-2">Car Discount %</label>
                            <input type="number" name="car_discount_percentage" id="car_discount_percentage" value="{{ old('car_discount_percentage', 0) }}" step="0.01" min="0" max="100"
                                   class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">
                            @error('car_discount_percentage')<span class="text-red-500 text-xs">{{ $message }}</span>@enderror
                        </div>

                        <div>
                            <label for="investment_bonus_percentage" class="block text-sm font-medium text-black mb-2">Investment Bonus %</label>
                            <input type="number" name="investment_bonus_percentage" id="investment_bonus_percentage" value="{{ old('investment_bonus_percentage', 0) }}" step="0.01" min="0" max="100"
                                   class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">
                            @error('investment_bonus_percentage')<span class="text-red-500 text-xs">{{ $message }}</span>@enderror
                        </div>

                        <div>
                            <label for="giveaway_entry_multiplier" class="block text-sm font-medium text-black mb-2">Giveaway Entry Multiplier</label>
                            <input type="number" name="giveaway_entry_multiplier" id="giveaway_entry_multiplier" value="{{ old('giveaway_entry_multiplier', 1) }}" min="1"
                                   class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">
                            @error('giveaway_entry_multiplier')<span class="text-red-500 text-xs">{{ $message }}</span>@enderror
                        </div>

                        <div>
                            <label for="sort_order" class="block text-sm font-medium text-black mb-2">Sort Order</label>
                            <input type="number" name="sort_order" id="sort_order" value="{{ old('sort_order', 0) }}" min="0"
                                   class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">
                            @error('sort_order')<span class="text-red-500 text-xs">{{ $message }}</span>@enderror
                        </div>

                        <div class="md:col-span-2">
                            <label for="benefits" class="block text-sm font-medium text-black mb-2">Benefits (one per line)</label>
                            <textarea name="benefits" id="benefits" rows="5" placeholder="Priority customer support&#10;Exclusive member events&#10;Early access to new cars"
                                      class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">{{ old('benefits') }}</textarea>
                            @error('benefits')<span class="text-red-500 text-xs">{{ $message }}</span>@enderror
                        </div>

                        <div class="md:col-span-2 space-y-3">
                            <div class="flex items-center">
                                <input type="checkbox" name="priority_support" id="priority_support" value="1" {{ old('priority_support') ? 'checked' : '' }}
                                       class="w-4 h-4 text-black border-gray-200 rounded focus:ring-black">
                                <label for="priority_support" class="ml-2 text-sm text-black">Priority Support</label>
                            </div>

                            <div class="flex items-center">
                                <input type="checkbox" name="is_active" id="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}
                                       class="w-4 h-4 text-black border-gray-200 rounded focus:ring-black">
                                <label for="is_active" class="ml-2 text-sm text-black">Active</label>
                            </div>
                        </div>
                    </div>

                    <div class="mt-6 flex justify-end space-x-3">
                        <a href="{{ route('admin.memberships.tiers.index') }}" class="px-4 py-2 border border-gray-200 rounded-lg text-black hover:bg-gray-50 text-sm">
                            Cancel
                        </a>
                        <button type="submit" class="bg-black text-white px-4 py-2 rounded-lg hover:bg-gray-800 text-sm">
                            Create Tier
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-admin-layout>
