<x-admin-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-light text-lg text-black leading-tight">
                Purchase #{{ $purchase->transaction_id }}
            </h2>
            <a href="{{ route('admin.memberships.purchases.index') }}" class="px-4 py-2 border border-gray-200 rounded-lg text-black hover:bg-gray-50 text-sm">
                Back to Purchases
            </a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8 space-y-6">
            <!-- Purchase Details -->
            <div class="bg-white border border-gray-200 rounded-lg p-6">
                <h3 class="text-lg font-medium text-black mb-4">Purchase Details</h3>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <p class="text-xs text-gray-500 mb-1">Transaction ID</p>
                        <p class="text-sm text-black font-mono">{{ $purchase->transaction_id }}</p>
                    </div>

                    <div>
                        <p class="text-xs text-gray-500 mb-1">Status</p>
                        <span class="inline-flex items-center px-2 py-1 text-xs font-medium rounded {{ $purchase->status_badge }}">
                            {{ ucfirst($purchase->status) }}
                        </span>
                    </div>

                    <div>
                        <p class="text-xs text-gray-500 mb-1">Amount</p>
                        <p class="text-sm text-black">{{ $purchase->formatted_amount }}</p>
                    </div>

                    <div>
                        <p class="text-xs text-gray-500 mb-1">Payment Method</p>
                        <p class="text-sm text-black">{{ $purchase->payment_method_label }}</p>
                    </div>

                    <div>
                        <p class="text-xs text-gray-500 mb-1">Created At</p>
                        <p class="text-sm text-black">{{ $purchase->created_at->format('M d, Y H:i') }}</p>
                    </div>

                    @if($purchase->completed_at)
                    <div>
                        <p class="text-xs text-gray-500 mb-1">Completed At</p>
                        <p class="text-sm text-black">{{ $purchase->completed_at->format('M d, Y H:i') }}</p>
                    </div>
                    @endif

                    @if($purchase->admin_notes)
                    <div class="md:col-span-2">
                        <p class="text-xs text-gray-500 mb-1">Admin Notes</p>
                        <p class="text-sm text-black">{{ $purchase->admin_notes }}</p>
                    </div>
                    @endif
                </div>
            </div>

            <!-- User Details -->
            <div class="bg-white border border-gray-200 rounded-lg p-6">
                <h3 class="text-lg font-medium text-black mb-4">User Details</h3>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <p class="text-xs text-gray-500 mb-1">Name</p>
                        <p class="text-sm text-black">{{ $purchase->user->name }}</p>
                    </div>

                    <div>
                        <p class="text-xs text-gray-500 mb-1">Email</p>
                        <p class="text-sm text-black">{{ $purchase->user->email }}</p>
                    </div>

                    <div>
                        <p class="text-xs text-gray-500 mb-1">User ID</p>
                        <p class="text-sm text-black">#{{ $purchase->user->id }}</p>
                    </div>

                    <div>
                        <p class="text-xs text-gray-500 mb-1">Member Since</p>
                        <p class="text-sm text-black">{{ $purchase->user->created_at->format('M d, Y') }}</p>
                    </div>
                </div>
            </div>

            <!-- Membership Tier Details -->
            <div class="bg-white border border-gray-200 rounded-lg p-6">
                <h3 class="text-lg font-medium text-black mb-4">Membership Tier</h3>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <p class="text-xs text-gray-500 mb-1">Tier Name</p>
                        <p class="text-sm text-black">{{ $purchase->membershipTier->name }}</p>
                    </div>

                    <div>
                        <p class="text-xs text-gray-500 mb-1">Price</p>
                        <p class="text-sm text-black">{{ $purchase->membershipTier->formatted_price }}</p>
                    </div>

                    <div>
                        <p class="text-xs text-gray-500 mb-1">Duration</p>
                        <p class="text-sm text-black">{{ $purchase->membershipTier->duration_in_months }}</p>
                    </div>

                    <div>
                        <p class="text-xs text-gray-500 mb-1">Car Discount</p>
                        <p class="text-sm text-black">{{ $purchase->membershipTier->car_discount_percentage }}%</p>
                    </div>

                    <div class="md:col-span-2">
                        <p class="text-xs text-gray-500 mb-2">Benefits</p>
                        <div class="space-y-1">
                            @foreach($purchase->membershipTier->benefits as $benefit)
                            <div class="flex items-center text-sm text-black">
                                <svg class="w-4 h-4 text-green-600 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                </svg>
                                {{ $benefit }}
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>

            <!-- Membership Card (if completed) -->
            @if($purchase->membershipCard)
            <div class="bg-white border border-gray-200 rounded-lg p-6">
                <h3 class="text-lg font-medium text-black mb-4">Membership Card</h3>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <p class="text-xs text-gray-500 mb-1">Card Number</p>
                        <p class="text-sm text-black font-mono">{{ $purchase->membershipCard->card_number }}</p>
                    </div>

                    <div>
                        <p class="text-xs text-gray-500 mb-1">Status</p>
                        <span class="inline-flex items-center px-2 py-1 text-xs font-medium rounded {{ $purchase->membershipCard->status_badge }}">
                            {{ ucfirst($purchase->membershipCard->status) }}
                        </span>
                    </div>

                    <div>
                        <p class="text-xs text-gray-500 mb-1">Issued At</p>
                        <p class="text-sm text-black">{{ $purchase->membershipCard->issued_at->format('M d, Y') }}</p>
                    </div>

                    <div>
                        <p class="text-xs text-gray-500 mb-1">Expires At</p>
                        <p class="text-sm text-black">{{ $purchase->membershipCard->expires_at->format('M d, Y') }}</p>
                    </div>
                </div>
            </div>
            @endif

            <!-- Actions -->
            @if($purchase->status === 'pending')
            <div class="bg-white border border-gray-200 rounded-lg p-6">
                <h3 class="text-lg font-medium text-black mb-4">Actions</h3>
                
                <div class="flex space-x-3">
                    <form action="{{ route('admin.memberships.purchases.approve', $purchase) }}" method="POST">
                        @csrf
                        <button type="submit" class="bg-green-600 text-white px-6 py-2 rounded-lg hover:bg-green-700 text-sm" onclick="return confirm('Approve this membership purchase?')">
                            Approve Purchase
                        </button>
                    </form>

                    <button onclick="openRejectModal()" class="bg-red-600 text-white px-6 py-2 rounded-lg hover:bg-red-700 text-sm">
                        Reject Purchase
                    </button>
                </div>
            </div>

            <!-- Rejection Modal -->
            <div id="rejectModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50">
                <div class="bg-white rounded-lg p-6 max-w-md w-full mx-4">
                    <h3 class="text-lg font-medium text-black mb-4">Reject Purchase</h3>
                    <form action="{{ route('admin.memberships.purchases.reject', $purchase) }}" method="POST">
                        @csrf
                        <div class="mb-4">
                            <label for="admin_notes" class="block text-sm font-medium text-black mb-2">Reason for Rejection*</label>
                            <textarea name="admin_notes" id="admin_notes" rows="4" required
                                      class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-black"></textarea>
                        </div>
                        <div class="flex justify-end space-x-3">
                            <button type="button" onclick="closeRejectModal()" class="px-4 py-2 border border-gray-200 rounded-lg text-black hover:bg-gray-50 text-sm">
                                Cancel
                            </button>
                            <button type="submit" class="bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700 text-sm">
                                Reject & Refund
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            @endif
        </div>
    </div>

    <script>
        function openRejectModal() {
            document.getElementById('rejectModal').classList.remove('hidden');
            document.getElementById('rejectModal').classList.add('flex');
        }

        function closeRejectModal() {
            document.getElementById('rejectModal').classList.add('hidden');
            document.getElementById('rejectModal').classList.remove('flex');
        }
    </script>
</x-admin-layout>
