<x-admin-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-light text-lg text-black leading-tight">
                {{ $giveaway->title }}
            </h2>
            <div class="flex space-x-3">
                <a href="{{ route('admin.giveaways.edit', $giveaway) }}" class="px-4 py-2 border border-gray-200 rounded-lg text-black hover:bg-gray-50 text-sm">
                    Edit
                </a>
                @if(!$giveaway->has_winner && $giveaway->status === 'ended')
                    <form action="{{ route('admin.giveaways.select-winner', $giveaway) }}" method="POST" class="inline">
                        @csrf
                        <button type="submit" class="bg-black text-white px-4 py-2 rounded-lg hover:bg-gray-800 text-sm" onclick="return confirm('Select a random winner for this giveaway?')">
                            Select Winner
                        </button>
                    </form>
                @endif
            </div>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-6">
            <!-- Giveaway Details -->
            <div class="bg-white border border-gray-200 rounded-lg p-6">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <!-- Image -->
                    <div class="md:col-span-1">
                        <img src="{{ $giveaway->image_url }}" alt="{{ $giveaway->title }}" class="w-full h-64 object-cover rounded-lg border border-gray-200">
                    </div>

                    <!-- Details -->
                    <div class="md:col-span-2">
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <p class="text-xs text-gray-500 mb-1">Status</p>
                                <span class="inline-flex items-center px-2 py-1 text-xs font-medium rounded {{ $giveaway->status_badge }}">
                                    {{ ucfirst($giveaway->status) }}
                                </span>
                            </div>

                            <div>
                                <p class="text-xs text-gray-500 mb-1">Prize Type</p>
                                <p class="text-sm text-black">{{ ucfirst($giveaway->prize_type) }}</p>
                            </div>

                            <div>
                                <p class="text-xs text-gray-500 mb-1">Prize Value</p>
                                <p class="text-sm text-black">{{ $giveaway->formatted_prize_value }}</p>
                            </div>

                            @if($giveaway->prize_car_id)
                            <div>
                                <p class="text-xs text-gray-500 mb-1">Prize Car</p>
                                <p class="text-sm text-black">{{ $giveaway->car->title ?? 'N/A' }}</p>
                            </div>
                            @endif

                            <div>
                                <p class="text-xs text-gray-500 mb-1">Entry Requirement</p>
                                <p class="text-sm text-black">{{ $giveaway->entry_requirement_label }}</p>
                            </div>

                            <div>
                                <p class="text-xs text-gray-500 mb-1">Featured</p>
                                <p class="text-sm text-black">{{ $giveaway->is_featured ? 'Yes' : 'No' }}</p>
                            </div>

                            <div>
                                <p class="text-xs text-gray-500 mb-1">Start Date</p>
                                <p class="text-sm text-black">{{ $giveaway->start_date ? $giveaway->start_date->format('M d, Y H:i') : 'N/A' }}</p>
                            </div>

                            <div>
                                <p class="text-xs text-gray-500 mb-1">End Date</p>
                                <p class="text-sm text-black">{{ $giveaway->end_date ? $giveaway->end_date->format('M d, Y H:i') : 'N/A' }}</p>
                            </div>

                            @if($giveaway->description)
                            <div class="col-span-2">
                                <p class="text-xs text-gray-500 mb-1">Description</p>
                                <p class="text-sm text-black">{{ $giveaway->description }}</p>
                            </div>
                            @endif

                            @if($giveaway->prize_details)
                            <div class="col-span-2">
                                <p class="text-xs text-gray-500 mb-1">Prize Details</p>
                                <p class="text-sm text-black">{{ $giveaway->prize_details }}</p>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Statistics -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div class="bg-white border border-gray-200 rounded-lg p-4">
                    <p class="text-xs text-gray-500 mb-1">Total Entries</p>
                    <p class="text-2xl font-semibold text-black">{{ number_format($giveaway->total_entries) }}</p>
                </div>
                <div class="bg-white border border-gray-200 rounded-lg p-4">
                    <p class="text-xs text-gray-500 mb-1">Unique Participants</p>
                    <p class="text-2xl font-semibold text-black">{{ number_format($giveaway->unique_participants) }}</p>
                </div>
                <div class="bg-white border border-gray-200 rounded-lg p-4">
                    <p class="text-xs text-gray-500 mb-1">Days Remaining</p>
                    <p class="text-2xl font-semibold text-black">{{ $giveaway->days_remaining }}</p>
                </div>
                <div class="bg-white border border-gray-200 rounded-lg p-4">
                    <p class="text-xs text-gray-500 mb-1">Winner</p>
                    <p class="text-2xl font-semibold text-black">{{ $giveaway->winner ? $giveaway->winner->name : 'Not selected' }}</p>
                </div>
            </div>

            <!-- Winner Section -->
            @if($giveaway->winner)
            <div class="bg-white border border-gray-200 rounded-lg p-6">
                <h3 class="text-lg font-medium text-black mb-4">Winner</h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <p class="text-xs text-gray-500 mb-1">Name</p>
                        <p class="text-sm text-black">{{ $giveaway->winner->name }}</p>
                    </div>
                    <div>
                        <p class="text-xs text-gray-500 mb-1">Email</p>
                        <p class="text-sm text-black">{{ $giveaway->winner->email }}</p>
                    </div>
                    <div>
                        <p class="text-xs text-gray-500 mb-1">Entries</p>
                        <p class="text-sm text-black">{{ $giveaway->entries()->where('user_id', $giveaway->winner_user_id)->first()->entries_count ?? 1 }}</p>
                    </div>
                </div>
            </div>
            @endif

            <!-- Entries List -->
            <div class="bg-white border border-gray-200 rounded-lg p-6">
                <h3 class="text-lg font-medium text-black mb-4">Entries</h3>
                
                @if($entries->count() > 0)
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead>
                                <tr class="bg-gray-50">
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">User</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Entries</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Source</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Entered At</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200">
                                @foreach($entries as $entry)
                                <tr class="hover:bg-gray-50">
                                    <td class="px-4 py-3 text-sm text-black">
                                        {{ $entry->user->name }}
                                        <span class="text-xs text-gray-500 block">{{ $entry->user->email }}</span>
                                    </td>
                                    <td class="px-4 py-3 text-sm text-black">
                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $entry->entries_count > 1 ? 'bg-yellow-100 text-yellow-800' : 'bg-gray-100 text-gray-800' }}">
                                            {{ $entry->entries_count }}
                                        </span>
                                    </td>
                                    <td class="px-4 py-3 text-sm text-black">{{ $entry->entry_source_label }}</td>
                                    <td class="px-4 py-3 text-sm text-gray-500">{{ $entry->entered_at->format('M d, Y H:i') }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        {{ $entries->links() }}
                    </div>
                @else
                    <p class="text-center text-gray-500 py-8">No entries yet.</p>
                @endif
            </div>
        </div>
    </div>
</x-admin-layout>
