<x-admin-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-light text-lg text-black leading-tight">
                Giveaways
            </h2>
            <a href="{{ route('admin.giveaways.create') }}" class="bg-black text-white px-4 py-2 rounded-lg hover:bg-gray-800 transition-colors text-sm">
                Create Giveaway
            </a>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Filters -->
            <div class="bg-white border border-gray-200 rounded-lg p-4 mb-6">
                <form method="GET" class="flex space-x-4">
                    <select name="status" onchange="this.form.submit()" class="px-3 py-2 border border-gray-200 rounded-lg text-sm focus:outline-none focus:ring-2 focus:ring-black">
                        <option value="">All Status</option>
                        <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>Draft</option>
                        <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                        <option value="ended" {{ request('status') == 'ended' ? 'selected' : '' }}>Ended</option>
                        <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                    </select>
                </form>
            </div>

            <div class="bg-white border border-gray-200 rounded-lg p-6">
                @if($giveaways->count() > 0)
                    <div class="grid grid-cols-1 gap-4">
                        @foreach($giveaways as $giveaway)
                        <div class="border border-gray-200 rounded-lg p-4 hover:bg-gray-50 transition-colors">
                            <div class="flex items-center">
                                <!-- Image -->
                                <div class="w-24 h-24 bg-gray-200 rounded-lg mr-4 flex-shrink-0 overflow-hidden">
                                    <img src="{{ $giveaway->image_url }}" alt="{{ $giveaway->title }}" class="w-full h-full object-cover">
                                </div>

                                <!-- Details -->
                                <div class="flex-1 min-w-0">
                                    <div class="flex items-start justify-between mb-2">
                                        <div>
                                            <h3 class="text-lg font-medium text-black">{{ $giveaway->title }}</h3>
                                            <p class="text-sm text-gray-600">{{ ucfirst($giveaway->prize_type) }} • {{ $giveaway->formatted_prize_value }}</p>
                                        </div>
                                        <span class="inline-flex items-center px-2 py-1 text-xs font-medium rounded {{ $giveaway->status_badge }}">
                                            {{ ucfirst($giveaway->status) }}
                                        </span>
                                    </div>

                                    <div class="grid grid-cols-4 gap-4 text-sm mb-2">
                                        <div>
                                            <span class="text-gray-500">Start:</span>
                                            <span class="text-black">{{ $giveaway->start_date ? $giveaway->start_date->format('M d, Y') : 'N/A' }}</span>
                                        </div>
                                        <div>
                                            <span class="text-gray-500">End:</span>
                                            <span class="text-black">{{ $giveaway->end_date ? $giveaway->end_date->format('M d, Y') : 'N/A' }}</span>
                                        </div>
                                        <div>
                                            <span class="text-gray-500">Entries:</span>
                                            <span class="text-black">{{ number_format($giveaway->total_entries) }}</span>
                                        </div>
                                        <div>
                                            <span class="text-gray-500">Participants:</span>
                                            <span class="text-black">{{ number_format($giveaway->unique_participants) }}</span>
                                        </div>
                                    </div>

                                    <div class="flex items-center space-x-3">
                                        <a href="{{ route('admin.giveaways.show', $giveaway) }}" class="text-sm text-black hover:text-gray-600">View</a>
                                        <a href="{{ route('admin.giveaways.edit', $giveaway) }}" class="text-sm text-black hover:text-gray-600">Edit</a>
                                        @if(!$giveaway->has_winner && $giveaway->status === 'ended')
                                            <form action="{{ route('admin.giveaways.select-winner', $giveaway) }}" method="POST" class="inline">
                                                @csrf
                                                <button type="submit" class="text-sm text-green-600 hover:text-green-800" onclick="return confirm('Select a random winner for this giveaway?')">
                                                    Select Winner
                                                </button>
                                            </form>
                                        @endif
                                        <form action="{{ route('admin.giveaways.destroy', $giveaway) }}" method="POST" class="inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-sm text-red-600 hover:text-red-800" onclick="return confirm('Are you sure?')">Delete</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>

                    <div class="mt-6">
                        {{ $giveaways->links() }}
                    </div>
                @else
                    <div class="text-center py-12">
                        <p class="text-gray-500 text-sm mb-4">No giveaways found.</p>
                        <a href="{{ route('admin.giveaways.create') }}" class="bg-black text-white px-4 py-2 rounded-lg hover:bg-gray-800 transition-colors text-sm inline-block">
                            Create First Giveaway
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</x-admin-layout>
