<x-admin-layout>
    <x-slot name="header">
        <h2 class="font-light text-lg text-black leading-tight">
            Create Giveaway
        </h2>
    </x-slot>

    <div class="py-8">
        <div class="max-w-3xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white border border-gray-200 rounded-lg p-6">
                <form action="{{ route('admin.giveaways.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="md:col-span-2">
                            <label for="title" class="block text-sm font-medium text-black mb-2">Title*</label>
                            <input type="text" name="title" id="title" value="{{ old('title') }}" required
                                   class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">
                            @error('title')<span class="text-red-500 text-xs">{{ $message }}</span>@enderror
                        </div>

                        <div class="md:col-span-2">
                            <label for="description" class="block text-sm font-medium text-black mb-2">Description</label>
                            <textarea name="description" id="description" rows="4"
                                      class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">{{ old('description') }}</textarea>
                            @error('description')<span class="text-red-500 text-xs">{{ $message }}</span>@enderror
                        </div>

                        <div class="md:col-span-2">
                            <label for="image" class="block text-sm font-medium text-black mb-2">Giveaway Image</label>
                            <input type="file" name="image" id="image" accept="image/*"
                                   class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">
                            @error('image')<span class="text-red-500 text-xs">{{ $message }}</span>@enderror
                        </div>

                        <div>
                            <label for="prize_type" class="block text-sm font-medium text-black mb-2">Prize Type*</label>
                            <select name="prize_type" id="prize_type" required onchange="togglePrizeFields()"
                                    class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">
                                <option value="car">Car</option>
                                <option value="cash">Cash</option>
                                <option value="investment">Investment</option>
                                <option value="other">Other</option>
                            </select>
                            @error('prize_type')<span class="text-red-500 text-xs">{{ $message }}</span>@enderror
                        </div>

                        <div>
                            <label for="prize_value" class="block text-sm font-medium text-black mb-2">Prize Value</label>
                            <input type="number" name="prize_value" id="prize_value" value="{{ old('prize_value') }}" step="0.01" min="0"
                                   class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">
                            @error('prize_value')<span class="text-red-500 text-xs">{{ $message }}</span>@enderror
                        </div>

                        <div id="car_field" class="md:col-span-2">
                            <label for="prize_car_id" class="block text-sm font-medium text-black mb-2">Prize Car</label>
                            <select name="prize_car_id" id="prize_car_id"
                                    class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">
                                <option value="">Select a car</option>
                                @foreach($cars as $car)
                                    <option value="{{ $car->id }}">{{ $car->title }} - {{ $car->formatted_price }}</option>
                                @endforeach
                            </select>
                            @error('prize_car_id')<span class="text-red-500 text-xs">{{ $message }}</span>@enderror
                        </div>

                        <div class="md:col-span-2">
                            <label for="prize_details" class="block text-sm font-medium text-black mb-2">Prize Details</label>
                            <textarea name="prize_details" id="prize_details" rows="3"
                                      class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">{{ old('prize_details') }}</textarea>
                            @error('prize_details')<span class="text-red-500 text-xs">{{ $message }}</span>@enderror
                        </div>

                        <div>
                            <label for="entry_requirement" class="block text-sm font-medium text-black mb-2">Entry Requirement*</label>
                            <select name="entry_requirement" id="entry_requirement" required
                                    class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">
                                <option value="none">Anyone Can Enter</option>
                                <option value="membership">VIP Members Only</option>
                                <option value="purchase">Car Purchase Required</option>
                                <option value="both">VIP Members Who Purchased</option>
                            </select>
                            @error('entry_requirement')<span class="text-red-500 text-xs">{{ $message }}</span>@enderror
                        </div>

                        <div>
                            <label for="max_entries" class="block text-sm font-medium text-black mb-2">Max Entries (optional)</label>
                            <input type="number" name="max_entries" id="max_entries" value="{{ old('max_entries') }}" min="1"
                                   class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">
                            @error('max_entries')<span class="text-red-500 text-xs">{{ $message }}</span>@enderror
                        </div>

                        <div>
                            <label for="start_date" class="block text-sm font-medium text-black mb-2">Start Date*</label>
                            <input type="datetime-local" name="start_date" id="start_date" value="{{ old('start_date') }}" required
                                   class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">
                            @error('start_date')<span class="text-red-500 text-xs">{{ $message }}</span>@enderror
                        </div>

                        <div>
                            <label for="end_date" class="block text-sm font-medium text-black mb-2">End Date*</label>
                            <input type="datetime-local" name="end_date" id="end_date" value="{{ old('end_date') }}" required
                                   class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">
                            @error('end_date')<span class="text-red-500 text-xs">{{ $message }}</span>@enderror
                        </div>

                        <div>
                            <label for="status" class="block text-sm font-medium text-black mb-2">Status*</label>
                            <select name="status" id="status" required
                                    class="w-full px-3 py-2 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-black">
                                <option value="draft">Draft</option>
                                <option value="active">Active</option>
                                <option value="ended">Ended</option>
                                <option value="cancelled">Cancelled</option>
                            </select>
                            @error('status')<span class="text-red-500 text-xs">{{ $message }}</span>@enderror
                        </div>

                        <div class="flex items-center">
                            <input type="checkbox" name="is_featured" id="is_featured" value="1" {{ old('is_featured') ? 'checked' : '' }}
                                   class="w-4 h-4 text-black border-gray-200 rounded focus:ring-black">
                            <label for="is_featured" class="ml-2 text-sm text-black">Featured Giveaway</label>
                        </div>
                    </div>

                    <div class="mt-6 flex justify-end space-x-3">
                        <a href="{{ route('admin.giveaways.index') }}" class="px-4 py-2 border border-gray-200 rounded-lg text-black hover:bg-gray-50 text-sm">
                            Cancel
                        </a>
                        <button type="submit" class="bg-black text-white px-4 py-2 rounded-lg hover:bg-gray-800 text-sm">
                            Create Giveaway
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        function togglePrizeFields() {
            const prizeType = document.getElementById('prize_type').value;
            const carField = document.getElementById('car_field');
            carField.style.display = prizeType === 'car' ? 'block' : 'none';
        }
        togglePrizeFields();
    </script>
</x-admin-layout>
