<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            // General Settings
            [
                'key' => 'site_name',
                'value' => 'Tesla Investment Platform',
                'type' => 'text',
                'group' => 'general',
                'label' => 'Site Name',
                'description' => 'The name of your website',
                'is_public' => true,
            ],
            [
                'key' => 'site_url',
                'value' => 'https://tesla.cycloverseworld.info',
                'type' => 'text',
                'group' => 'general',
                'label' => 'Site URL',
                'description' => 'The main URL of your website',
                'is_public' => true,
            ],
            [
                'key' => 'site_email',
                'value' => 'admin@tesla.cycloverseworld.info',
                'type' => 'text',
                'group' => 'general',
                'label' => 'Site Email',
                'description' => 'Primary contact email for the website',
                'is_public' => true,
            ],
            [
                'key' => 'site_phone',
                'value' => '+1 (555) 123-4567',
                'type' => 'text',
                'group' => 'general',
                'label' => 'Site Phone',
                'description' => 'Primary contact phone number',
                'is_public' => true,
            ],
            [
                'key' => 'site_logo',
                'value' => null,
                'type' => 'image',
                'group' => 'appearance',
                'label' => 'Site Logo',
                'description' => 'Upload your site logo (recommended: 200x60px)',
                'is_public' => true,
            ],
            [
                'key' => 'site_favicon',
                'value' => null,
                'type' => 'image',
                'group' => 'appearance',
                'label' => 'Site Favicon',
                'description' => 'Upload your site favicon (SVG, PNG, ICO supported)',
                'is_public' => true,
            ],
            [
                'key' => 'enable_kyc',
                'value' => '1',
                'type' => 'checkbox',
                'group' => 'security',
                'label' => 'Enable KYC Verification',
                'description' => 'Require users to complete KYC verification',
                'is_public' => false,
            ],
            [
                'key' => 'enable_email_verification',
                'value' => '1',
                'type' => 'checkbox',
                'group' => 'security',
                'label' => 'Enable Email Verification',
                'description' => 'Require users to verify their email address',
                'is_public' => false,
            ],
            [
                'key' => 'maintenance_mode',
                'value' => '0',
                'type' => 'checkbox',
                'group' => 'general',
                'label' => 'Maintenance Mode',
                'description' => 'Put the site in maintenance mode',
                'is_public' => false,
            ],
            [
                'key' => 'site_description',
                'value' => 'Your trusted platform for investments and financial growth',
                'type' => 'textarea',
                'group' => 'general',
                'label' => 'Site Description',
                'description' => 'Brief description of your website',
                'is_public' => true,
            ],
            [
                'key' => 'site_keywords',
                'value' => 'investment, stocks, crypto, trading, finance',
                'type' => 'textarea',
                'group' => 'general',
                'label' => 'Site Keywords',
                'description' => 'SEO keywords for your website',
                'is_public' => true,
            ],
            [
                'key' => 'footer_text',
                'value' => '© 2024 Tesla Investment Platform. All rights reserved.',
                'type' => 'textarea',
                'group' => 'appearance',
                'label' => 'Footer Text',
                'description' => 'Text displayed in the footer',
                'is_public' => true,
            ],
            [
                'key' => 'enable_whatsapp_chat',
                'value' => '1',
                'type' => 'checkbox',
                'group' => 'communication',
                'label' => 'Enable WhatsApp Chat',
                'description' => 'Show WhatsApp chat widget on the website',
                'is_public' => false,
            ],
            [
                'key' => 'whatsapp_number',
                'value' => '+1234567890',
                'type' => 'text',
                'group' => 'communication',
                'label' => 'WhatsApp Number',
                'description' => 'WhatsApp number with country code (e.g., +1234567890)',
                'is_public' => true,
            ],
            [
                'key' => 'whatsapp_message',
                'value' => 'Hello, I need support about...',
                'type' => 'textarea',
                'group' => 'communication',
                'label' => 'WhatsApp Pre-filled Message',
                'description' => 'Default message that appears when users click the WhatsApp button',
                'is_public' => true,
            ],
            [
                'key' => 'enable_telegram_chat',
                'value' => '1',
                'type' => 'checkbox',
                'group' => 'communication',
                'label' => 'Enable Telegram Chat',
                'description' => 'Show Telegram chat button on the website',
                'is_public' => false,
            ],
            [
                'key' => 'telegram_username',
                'value' => 'betawealthfx_3',
                'type' => 'text',
                'group' => 'communication',
                'label' => 'Telegram Username',
                'description' => 'Your Telegram username (without @)',
                'is_public' => true,
            ],
            // Tawk.to Live Chat
            [
                'key' => 'enable_tawk_chat',
                'value' => '0',
                'type' => 'checkbox',
                'group' => 'livechat',
                'label' => 'Enable Tawk.to Chat',
                'description' => 'Enable Tawk.to live chat widget',
                'is_public' => false,
            ],
            [
                'key' => 'tawk_property_id',
                'value' => '',
                'type' => 'text',
                'group' => 'livechat',
                'label' => 'Tawk.to Property ID',
                'description' => 'Your Tawk.to property ID (e.g., 5f9a1b2c3d4e5f6g7h8i9j0k)',
                'is_public' => true,
            ],
            [
                'key' => 'tawk_widget_id',
                'value' => '',
                'type' => 'text',
                'group' => 'livechat',
                'label' => 'Tawk.to Widget ID',
                'description' => 'Your Tawk.to widget ID (default)',
                'is_public' => true,
            ],
            // Tidio Live Chat
            [
                'key' => 'enable_tidio_chat',
                'value' => '0',
                'type' => 'checkbox',
                'group' => 'livechat',
                'label' => 'Enable Tidio Chat',
                'description' => 'Enable Tidio live chat widget',
                'is_public' => false,
            ],
            [
                'key' => 'tidio_public_key',
                'value' => '',
                'type' => 'text',
                'group' => 'livechat',
                'label' => 'Tidio Public Key',
                'description' => 'Your Tidio public key (e.g., abcdefghijklmnopqrstuvwxyz123456)',
                'is_public' => true,
            ],
            // Smartsupp Live Chat
            [
                'key' => 'enable_smartsupp_chat',
                'value' => '0',
                'type' => 'checkbox',
                'group' => 'livechat',
                'label' => 'Enable Smartsupp Chat',
                'description' => 'Enable Smartsupp live chat widget',
                'is_public' => false,
            ],
            [
                'key' => 'smartsupp_key',
                'value' => '',
                'type' => 'text',
                'group' => 'livechat',
                'label' => 'Smartsupp Chat Key',
                'description' => 'Your Smartsupp chat key (e.g., 1234567890abcdef)',
                'is_public' => true,
            ],
            // Intercom Live Chat
            [
                'key' => 'enable_intercom_chat',
                'value' => '0',
                'type' => 'checkbox',
                'group' => 'livechat',
                'label' => 'Enable Intercom Chat',
                'description' => 'Enable Intercom live chat widget',
                'is_public' => false,
            ],
            [
                'key' => 'intercom_app_id',
                'value' => '',
                'type' => 'text',
                'group' => 'livechat',
                'label' => 'Intercom App ID',
                'description' => 'Your Intercom app ID (e.g., abc12345)',
                'is_public' => true,
            ],
            // Crisp Live Chat
            [
                'key' => 'enable_crisp_chat',
                'value' => '0',
                'type' => 'checkbox',
                'group' => 'livechat',
                'label' => 'Enable Crisp Chat',
                'description' => 'Enable Crisp live chat widget',
                'is_public' => false,
            ],
            [
                'key' => 'crisp_website_id',
                'value' => '',
                'type' => 'text',
                'group' => 'livechat',
                'label' => 'Crisp Website ID',
                'description' => 'Your Crisp website ID (e.g., 12345678-1234-1234-1234-123456789012)',
                'is_public' => true,
            ],
            // LiveChat
            [
                'key' => 'enable_livechat',
                'value' => '0',
                'type' => 'checkbox',
                'group' => 'livechat',
                'label' => 'Enable LiveChat',
                'description' => 'Enable LiveChat widget',
                'is_public' => false,
            ],
            [
                'key' => 'livechat_license',
                'value' => '',
                'type' => 'text',
                'group' => 'livechat',
                'label' => 'LiveChat License',
                'description' => 'Your LiveChat license number (e.g., 12345678)',
                'is_public' => true,
            ],
        ];

        foreach ($settings as $setting) {
            DB::table('settings')->insert(array_merge($setting, [
                'created_at' => now(),
                'updated_at' => now(),
            ]));
        }
    }
}
