<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class InvestmentPlanSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        $plans = [
            [
                'name' => 'Tesla Growth Fund',
                'description' => 'High-growth fund focused on Tesla and electric vehicle technology companies',
                'type' => 'tesla_focused',
                'category' => 'Tesla-Focused',
                'nav' => 25.50,
                'nav_change_percentage' => 12.5,
                'minimum_investment' => 100.00,
                'management_fee' => 0.0085, // 0.85%
                'expense_ratio' => 0.0085,
                'risk_level' => 'high',
                'is_featured' => true,
                'is_active' => true,
                'inception_date' => '2020-01-15',
                'total_assets' => 2500000.00,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Sustainable Energy ETF',
                'description' => 'Exchange-traded fund focused on renewable energy and sustainable technology',
                'type' => 'etf',
                'category' => 'ESG',
                'nav' => 18.75,
                'nav_change_percentage' => 8.2,
                'minimum_investment' => 50.00,
                'management_fee' => 0.0075, // 0.75%
                'expense_ratio' => 0.0075,
                'risk_level' => 'medium',
                'is_featured' => true,
                'is_active' => true,
                'inception_date' => '2019-06-20',
                'total_assets' => 1800000.00,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Tesla Retirement Fund',
                'description' => 'Conservative fund designed for retirement planning with Tesla exposure',
                'type' => 'retirement',
                'category' => 'Conservative',
                'nav' => 15.20,
                'nav_change_percentage' => 3.8,
                'minimum_investment' => 250.00,
                'management_fee' => 0.0065, // 0.65%
                'expense_ratio' => 0.0065,
                'risk_level' => 'low',
                'is_featured' => false,
                'is_active' => true,
                'inception_date' => '2021-03-10',
                'total_assets' => 3200000.00,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Conservative Income Fund',
                'description' => 'Low-risk fund focused on generating stable income through dividends',
                'type' => 'mutual_fund',
                'category' => 'Income',
                'nav' => 12.80,
                'nav_change_percentage' => 2.1,
                'minimum_investment' => 500.00,
                'management_fee' => 0.0055, // 0.55%
                'expense_ratio' => 0.0055,
                'risk_level' => 'low',
                'is_featured' => false,
                'is_active' => true,
                'inception_date' => '2018-09-05',
                'total_assets' => 4500000.00,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Aggressive Growth Fund',
                'description' => 'High-risk, high-reward fund targeting maximum capital appreciation',
                'type' => 'mutual_fund',
                'category' => 'Growth',
                'nav' => 32.40,
                'nav_change_percentage' => 18.7,
                'minimum_investment' => 200.00,
                'management_fee' => 0.0095, // 0.95%
                'expense_ratio' => 0.0095,
                'risk_level' => 'high',
                'is_featured' => true,
                'is_active' => true,
                'inception_date' => '2020-11-12',
                'total_assets' => 1800000.00,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'ESG Balanced Fund',
                'description' => 'Balanced portfolio with environmental, social, and governance focus',
                'type' => 'mutual_fund',
                'category' => 'Balanced',
                'nav' => 22.15,
                'nav_change_percentage' => 6.3,
                'minimum_investment' => 150.00,
                'management_fee' => 0.0070, // 0.70%
                'expense_ratio' => 0.0070,
                'risk_level' => 'medium',
                'is_featured' => false,
                'is_active' => true,
                'inception_date' => '2021-07-22',
                'total_assets' => 2100000.00,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Tesla Technology Fund',
                'description' => 'Focused on Tesla and related technology companies in autonomous driving and AI',
                'type' => 'tesla_focused',
                'category' => 'Tesla-Focused',
                'nav' => 28.90,
                'nav_change_percentage' => 15.2,
                'minimum_investment' => 300.00,
                'management_fee' => 0.0080, // 0.80%
                'expense_ratio' => 0.0080,
                'risk_level' => 'high',
                'is_featured' => false,
                'is_active' => true,
                'inception_date' => '2022-02-14',
                'total_assets' => 1200000.00,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Dividend Income Fund',
                'description' => 'High-yield dividend fund for regular income generation',
                'type' => 'mutual_fund',
                'category' => 'Income',
                'nav' => 14.60,
                'nav_change_percentage' => 4.5,
                'minimum_investment' => 1000.00,
                'management_fee' => 0.0060, // 0.60%
                'expense_ratio' => 0.0060,
                'risk_level' => 'medium',
                'is_featured' => false,
                'is_active' => true,
                'inception_date' => '2019-12-03',
                'total_assets' => 3800000.00,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Global Growth Fund',
                'description' => 'Diversified growth fund with international exposure',
                'type' => 'mutual_fund',
                'category' => 'Growth',
                'nav' => 19.80,
                'nav_change_percentage' => 9.8,
                'minimum_investment' => 400.00,
                'management_fee' => 0.0080, // 0.80%
                'expense_ratio' => 0.0080,
                'risk_level' => 'medium',
                'is_featured' => false,
                'is_active' => true,
                'inception_date' => '2020-08-18',
                'total_assets' => 2900000.00,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Conservative Bond Fund',
                'description' => 'Ultra-conservative fund focused on government and corporate bonds',
                'type' => 'mutual_fund',
                'category' => 'Conservative',
                'nav' => 10.45,
                'nav_change_percentage' => 1.2,
                'minimum_investment' => 750.00,
                'management_fee' => 0.0045, // 0.45%
                'expense_ratio' => 0.0045,
                'risk_level' => 'low',
                'is_featured' => false,
                'is_active' => true,
                'inception_date' => '2017-05-30',
                'total_assets' => 5200000.00,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        DB::table('investment_plans')->insert($plans);
    }
} 