<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Giveaway;
use Carbon\Carbon;

class GiveawaySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $now = Carbon::now();
        
        $giveaways = [
            [
                'title' => 'Tesla Model S Plaid Giveaway',
                'description' => 'Win a brand new Tesla Model S Plaid! This luxury electric sedan features tri-motor all-wheel drive with up to 1,020 horsepower, 0-60 mph in under 2 seconds, and a range of up to 396 miles. The ultimate expression of performance and luxury.',
                'prize_type' => 'car',
                'prize_value' => 129990.00,
                'currency' => 'USD',
                'prize_details' => 'Brand new Tesla Model S Plaid with all standard features, delivery included, and 1 year of free Supercharging.',
                'max_entries' => 5000,
                'entry_requirement' => 'membership',
                'start_date' => $now,
                'end_date' => $now->copy()->addDays(30),
                'status' => 'active',
                'is_featured' => true,
            ],
            [
                'title' => '$50,000 Cash Prize Draw',
                'description' => 'Enter for a chance to win $50,000 in cash! Use it for anything you want - invest it, buy a car, pay off debt, or take the vacation of your dreams. No restrictions, pure cash prize!',
                'prize_type' => 'cash',
                'prize_value' => 50000.00,
                'currency' => 'USD',
                'prize_details' => '$50,000 USD cash transferred directly to your Tesla Investment wallet. Withdraw anytime or reinvest in your portfolio.',
                'max_entries' => null, // Unlimited entries
                'entry_requirement' => 'none',
                'start_date' => $now,
                'end_date' => $now->copy()->addDays(45),
                'status' => 'active',
                'is_featured' => true,
            ],
            [
                'title' => 'VIP Platinum Membership + $10,000 Investment Credit',
                'description' => 'Win a lifetime VIP Platinum membership plus $10,000 to invest in mutual funds and stocks. Enjoy exclusive benefits including priority support, investment bonuses, and special discounts forever!',
                'prize_type' => 'investment',
                'prize_value' => 10000.00,
                'currency' => 'USD',
                'prize_details' => 'Lifetime Platinum VIP membership (valued at $5,000) + $10,000 investment credit for stocks and mutual funds. Benefits include 1.0% bonus on investment returns, 5% discount on Tesla cars, 5x giveaway entries, and priority support.',
                'max_entries' => 1000,
                'entry_requirement' => 'purchase',
                'start_date' => $now,
                'end_date' => $now->copy()->addDays(60),
                'status' => 'active',
                'is_featured' => false,
            ],
            [
                'title' => 'Tesla Model 3 Performance Bundle',
                'description' => 'Drive away in a Tesla Model 3 Performance! This award-winning electric sedan delivers 0-60 mph in 3.1 seconds, dual motor AWD, 315 miles of range, and includes premium features like upgraded audio and full self-driving capability.',
                'prize_type' => 'car',
                'prize_value' => 55990.00,
                'currency' => 'USD',
                'prize_details' => 'Tesla Model 3 Performance with Enhanced Autopilot, premium interior, sport wheels, and 6 months of free Supercharging. Delivery and registration fees included.',
                'max_entries' => 3000,
                'entry_requirement' => 'both',
                'start_date' => $now->copy()->addDays(7),
                'end_date' => $now->copy()->addDays(37),
                'status' => 'active',
                'is_featured' => false,
            ],
            [
                'title' => 'Dream Vacation Package + $5,000 Spending Money',
                'description' => 'Win an all-expenses-paid luxury vacation for two to your choice of Hawaii, Maldives, or European tour, plus $5,000 spending money! First class flights, 5-star hotels, and unforgettable experiences await.',
                'prize_type' => 'other',
                'prize_value' => 20000.00,
                'currency' => 'USD',
                'prize_details' => 'Choice of 10-day Hawaii beach resort, 14-day Maldives luxury villa, or 21-day European tour package. Includes first class round-trip flights, 5-star accommodations, daily breakfast, and $5,000 cash for activities, dining, and shopping. Valid for 12 months from win date.',
                'max_entries' => 2000,
                'entry_requirement' => 'membership',
                'start_date' => $now->copy()->addDays(3),
                'end_date' => $now->copy()->addDays(33),
                'status' => 'active',
                'is_featured' => false,
            ],
        ];

        foreach ($giveaways as $giveaway) {
            Giveaway::create($giveaway);
        }

        $this->command->info('✅ Successfully created 5 giveaways!');
    }
}
