<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('giveaway_entries', function (Blueprint $table) {
            $table->id();
            $table->foreignId('giveaway_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->integer('entries_count')->default(1); // VIP multiplier applied
            $table->enum('entry_source', ['manual', 'car_purchase', 'membership_bonus'])->default('manual');
            $table->foreignId('source_purchase_id')->nullable()->constrained('purchases')->onDelete('set null');
            $table->timestamp('entered_at');
            $table->timestamps();
            
            $table->unique(['giveaway_id', 'user_id']); // One entry record per user per giveaway
            $table->index('user_id');
            $table->index('entered_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('giveaway_entries');
    }
};
