<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('giveaways', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('description')->nullable();
            $table->string('image_path')->nullable();
            $table->enum('prize_type', ['car', 'cash', 'investment', 'other'])->default('other');
            $table->decimal('prize_value', 15, 2)->nullable();
            $table->string('currency', 3)->default('USD');
            $table->foreignId('prize_car_id')->nullable()->constrained('cars')->onDelete('set null');
            $table->text('prize_details')->nullable();
            $table->integer('max_entries')->nullable(); // Null = unlimited
            $table->enum('entry_requirement', ['none', 'membership', 'purchase', 'both'])->default('none');
            $table->timestamp('start_date')->nullable();
            $table->timestamp('end_date')->nullable();
            $table->foreignId('winner_user_id')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('winner_selected_at')->nullable();
            $table->enum('status', ['draft', 'active', 'ended', 'cancelled'])->default('draft');
            $table->boolean('is_featured')->default(false);
            $table->timestamps();
            
            $table->index('status');
            $table->index('start_date');
            $table->index('end_date');
            $table->index('is_featured');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('giveaways');
    }
};
