<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        channels: __DIR__.'/../routes/channels.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        $middleware->alias([
            'admin' => \App\Http\Middleware\EnsureUserIsAdmin::class,
            'wallet' => \App\Http\Middleware\EnsureUserHasWallet::class,
            'kyc' => \App\Http\Middleware\KYCMiddleware::class,
            'block.admin' => \App\Http\Middleware\PreventAdminAccessToUserPages::class,
            'can.impersonate' => \App\Http\Middleware\EnsureUserCanImpersonate::class,
        ]);
        
        // Configure CSRF token exceptions if needed
        $middleware->validateCsrfTokens(except: [
            // Add routes here if you need to exclude them from CSRF protection
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        //
    })->create();
