<?php

namespace App\Jobs;

use App\Models\MembershipCard;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Support\Facades\Log;

class CheckMembershipExpiriesJob implements ShouldQueue
{
    use Queueable;

    /**
     * The number of times the job may be attempted.
     *
     * @var int
     */
    public $tries = 3;

    /**
     * The number of seconds the job can run before timing out.
     *
     * @var int
     */
    public $timeout = 300;

    /**
     * Create a new job instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        // Find all active membership cards that have expired
        $expiredCards = MembershipCard::where('status', 'active')
            ->where('expires_at', '<', now())
            ->get();

        $count = 0;
        foreach ($expiredCards as $card) {
            $card->markAsExpired();
            $count++;
        }

        Log::info("CheckMembershipExpiriesJob: Marked {$count} membership cards as expired");
    }
}
