<?php

namespace App\Http\Controllers;

use App\Models\MembershipCard;
use Illuminate\Http\Request;

class MembershipCardController extends Controller
{
    public function index()
    {
        $user = auth()->user();
        $activeCard = $user->getActiveMembershipCard();
        $cards = $user->membershipCards()->with('membershipTier')->latest()->get();
        
        return view('memberships.card', compact('activeCard', 'cards'));
    }

    public function show(MembershipCard $membershipCard)
    {
        // Ensure user owns this card
        if ($membershipCard->user_id !== auth()->id()) {
            abort(403);
        }

        $membershipCard->load('membershipTier');
        
        return view('memberships.show', compact('membershipCard'));
    }

    public function downloadPdf(MembershipCard $membershipCard)
    {
        // Ensure user owns this card
        if ($membershipCard->user_id !== auth()->id()) {
            abort(403);
        }

        $membershipCard->load('membershipTier', 'user');

        // Generate PDF using dompdf
        $pdf = \PDF::loadView('memberships.pdf', compact('membershipCard'));
        
        return $pdf->download('VIP-Membership-Card-' . $membershipCard->card_number . '.pdf');
    }
}
